/*
 * Decompiled with CFR 0.152.
 */
package org.wildscribe.logs;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.EnumMemberValue;
import javassist.bytecode.annotation.IntegerMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import org.jboss.logging.Logger;

public class MessageExporter {
    private static final Logger LOGGER = Logger.getLogger(MessageExporter.class);

    public static Path export(Path modulesDir, Path target) throws IOException {
        final ArrayList messages = new ArrayList();
        Files.walkFileTree(modulesDir, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.toString().endsWith(".jar")) {
                    MessageExporter.processJarFile(file, messages);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                return FileVisitResult.CONTINUE;
            }
        });
        try (DataOutputStream out = new DataOutputStream(Files.newOutputStream(target, new OpenOption[0]));){
            for (LogMessage message : messages) {
                out.writeUTF(message.code == null ? "" : message.code);
                out.writeUTF(message.level == null ? "" : message.level);
                out.writeUTF(message.returnType);
                out.writeUTF(message.message);
                out.writeInt(message.msgId);
                out.writeInt(message.length);
            }
        }
        return target;
    }

    private static void processJarFile(Path file, final Collection<LogMessage> messages) throws IOException {
        try (FileSystem zipFs = MessageExporter.zipFs(file);){
            for (Path dir : zipFs.getRootDirectories()) {
                Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        if (file.getFileName().toString().endsWith(".class")) {
                            try (DataInputStream d = new DataInputStream(Files.newInputStream(file, new OpenOption[0]));){
                                ClassFile classFile = new ClassFile(d);
                                MessageExporter.handleClass(classFile, messages);
                            }
                        }
                        return super.visitFile(file, attrs);
                    }
                });
            }
        }
    }

    private static void handleClass(ClassFile classFile, Collection<LogMessage> messages) {
        AnnotationsAttribute attr = (AnnotationsAttribute)classFile.getAttribute("RuntimeInvisibleAnnotations");
        if (attr == null) {
            return;
        }
        for (Annotation annotation : attr.getAnnotations()) {
            if (!"org.jboss.logging.annotations.MessageLogger".equals(annotation.getTypeName())) continue;
            String code = ((StringMemberValue)annotation.getMemberValue("projectCode")).getValue();
            MemberValue lengthValue = annotation.getMemberValue("length");
            int length = lengthValue == null ? 6 : ((IntegerMemberValue)lengthValue).getValue();
            MessageExporter.handleMessageLogger(classFile, code, length, messages);
        }
    }

    private static void handleMessageLogger(ClassFile classFile, String code, int length, Collection<LogMessage> messages) {
        LOGGER.debug(code);
        for (MethodInfo method : Collections.unmodifiableList(classFile.getMethods())) {
            String logLevel = null;
            String message = null;
            int msgId = -1;
            AnnotationsAttribute attr = (AnnotationsAttribute)method.getAttribute("RuntimeInvisibleAnnotations");
            if (attr == null) continue;
            for (Annotation annotation : attr.getAnnotations()) {
                if ("org.jboss.logging.annotations.LogMessage".equals(annotation.getTypeName())) {
                    MemberValue level = annotation.getMemberValue("level");
                    logLevel = level == null ? "INFO" : ((EnumMemberValue)level).getValue();
                    continue;
                }
                if (!"org.jboss.logging.annotations.Message".equals(annotation.getTypeName())) continue;
                message = ((StringMemberValue)annotation.getMemberValue("value")).getValue();
                MemberValue id = annotation.getMemberValue("id");
                if (id == null) continue;
                msgId = ((IntegerMemberValue)id).getValue();
            }
            if (message != null) {
                LogMessage l = new LogMessage(logLevel, code, message, length, msgId, MessageExporter.extractReturnType(method));
                messages.add(l);
            }
            LOGGER.debugf("%s %s: %s", (Object)logLevel, (Object)msgId, (Object)message);
        }
    }

    private static String extractReturnType(MethodInfo method) {
        String descriptor = method.getDescriptor();
        descriptor = descriptor.substring(descriptor.lastIndexOf(")") + 1);
        descriptor = descriptor.replace("/", ".");
        if ((descriptor = descriptor.replace(";", "")).startsWith("L")) {
            descriptor = descriptor.substring(1);
        }
        if ("V".equals(descriptor)) {
            return "void";
        }
        return descriptor;
    }

    private static FileSystem zipFs(Path path) throws IOException {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "true");
        return MessageExporter.zipFs(path, env);
    }

    private static FileSystem zipFs(Path path, Map<String, String> env) throws IOException {
        URI uri = URI.create("jar:" + path.toUri());
        try {
            return FileSystems.getFileSystem(uri);
        }
        catch (FileSystemNotFoundException fileSystemNotFoundException) {
            return FileSystems.newFileSystem(uri, env);
        }
    }

    private static final class LogMessage {
        final String level;
        final String code;
        final String message;
        final int length;
        final int msgId;
        final String returnType;

        private LogMessage(String level, String code, String message, int length, int msgId, String returnType) {
            this.level = level;
            this.code = code;
            this.message = message;
            this.length = length;
            this.msgId = msgId;
            this.returnType = returnType;
        }
    }
}

