/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.common.serviceref;

import javax.naming.BinaryRefAddr;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import org.jboss.wsf.common.serviceref.ServiceRefSerializer;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;

public abstract class AbstractServiceReferenceableJAXWS<T extends ObjectFactory>
implements Referenceable {
    private final String serviceImplClass;
    private final String targetClassName;
    private final UnifiedServiceRefMetaData serviceRef;

    public AbstractServiceReferenceableJAXWS(String serviceImplClass, String targetClassName, UnifiedServiceRefMetaData serviceRef) {
        this.serviceImplClass = serviceImplClass;
        this.targetClassName = targetClassName;
        this.serviceRef = serviceRef;
    }

    @Override
    public final Reference getReference() throws NamingException {
        Reference myRef = new Reference(this.getClass().getName(), this.getObjectFactory().getName(), null);
        myRef.add(new StringRefAddr("SERVICE_CLASS_NAME", this.serviceImplClass));
        myRef.add(new StringRefAddr("TARGET_CLASS_NAME", this.targetClassName));
        myRef.add(new BinaryRefAddr("SERVICE_REF_META_DATA", ServiceRefSerializer.marshall(this.serviceRef)));
        return myRef;
    }

    protected abstract Class<T> getObjectFactory();

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n").append(this.getClass().getName());
        sb.append("\n serviceImplClass=" + this.serviceImplClass);
        sb.append("\n targetClassName=" + this.targetClassName);
        sb.append("\n serviceRef=" + this.serviceRef);
        return sb.toString();
    }
}

