/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.common.injection;

import java.io.Serializable;
import java.security.Principal;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.handler.MessageContext;
import org.w3c.dom.Element;

public final class ThreadLocalAwareWebServiceContext
implements WebServiceContext,
Serializable {
    private static final long serialVersionUID = 126557512266764152L;
    private static final transient ThreadLocalAwareWebServiceContext SINGLETON = new ThreadLocalAwareWebServiceContext();
    private final transient ThreadLocal<WebServiceContext> contexts = new InheritableThreadLocal<WebServiceContext>();

    public static ThreadLocalAwareWebServiceContext getInstance() {
        return SINGLETON;
    }

    public void setMessageContext(WebServiceContext ctx) {
        this.contexts.set(ctx);
    }

    public EndpointReference getEndpointReference(Element ... referenceParameters) {
        WebServiceContext delegee = this.contexts.get();
        return delegee == null ? null : delegee.getEndpointReference(referenceParameters);
    }

    public <T extends EndpointReference> T getEndpointReference(Class<T> clazz, Element ... referenceParameters) {
        WebServiceContext delegee = this.contexts.get();
        return (T)(delegee == null ? null : delegee.getEndpointReference(clazz, referenceParameters));
    }

    public MessageContext getMessageContext() {
        WebServiceContext delegee = this.contexts.get();
        return delegee == null ? null : delegee.getMessageContext();
    }

    public Principal getUserPrincipal() {
        WebServiceContext delegee = this.contexts.get();
        return delegee == null ? null : delegee.getUserPrincipal();
    }

    public boolean isUserInRole(String role) {
        WebServiceContext delegee = this.contexts.get();
        return delegee == null ? false : delegee.isUserInRole(role);
    }
}

