/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.common.invocation;

import javax.xml.ws.WebServiceContext;
import org.jboss.wsf.common.injection.InjectionHelper;
import org.jboss.wsf.common.injection.PreDestroyHolder;
import org.jboss.wsf.common.injection.ThreadLocalAwareWebServiceContext;
import org.jboss.wsf.common.invocation.AbstractInvocationHandlerJSE;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.invocation.Invocation;
import org.jboss.wsf.spi.invocation.InvocationContext;
import org.jboss.wsf.spi.invocation.ResourceInjector;
import org.jboss.wsf.spi.invocation.ResourceInjectorFactory;
import org.jboss.wsf.spi.metadata.injection.InjectionsMetaData;

public final class InvocationHandlerJAXWS
extends AbstractInvocationHandlerJSE {
    @Override
    public void onEndpointInstantiated(Endpoint endpoint, Invocation invocation) {
        InjectionsMetaData injectionsMD = (InjectionsMetaData)endpoint.getAttachment(InjectionsMetaData.class);
        Object targetBean = this.getTargetBean(invocation);
        this.log.debug((Object)("Injecting resources on JAXWS JSE endpoint: " + targetBean));
        if (injectionsMD != null) {
            InjectionHelper.injectResources(targetBean, injectionsMD, endpoint.getJNDIContext());
        }
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        ResourceInjectorFactory resourceInjectorFactory = (ResourceInjectorFactory)spiProvider.getSPI(ResourceInjectorFactory.class);
        ResourceInjector wsContextInjector = resourceInjectorFactory.newResourceInjector();
        wsContextInjector.inject(targetBean, (WebServiceContext)ThreadLocalAwareWebServiceContext.getInstance());
        this.log.debug((Object)("Calling postConstruct method on JAXWS JSE endpoint: " + targetBean));
        InjectionHelper.callPostConstructMethod(targetBean);
        endpoint.addAttachment(PreDestroyHolder.class, (Object)new PreDestroyHolder(targetBean));
    }

    @Override
    public void onBeforeInvocation(Invocation invocation) {
        WebServiceContext wsContext = this.getWebServiceContext(invocation);
        ThreadLocalAwareWebServiceContext.getInstance().setMessageContext(wsContext);
    }

    @Override
    public void onAfterInvocation(Invocation invocation) {
        ThreadLocalAwareWebServiceContext.getInstance().setMessageContext(null);
    }

    private WebServiceContext getWebServiceContext(Invocation invocation) {
        InvocationContext invocationContext = invocation.getInvocationContext();
        return (WebServiceContext)invocationContext.getAttachment(WebServiceContext.class);
    }

    private Object getTargetBean(Invocation invocation) {
        InvocationContext invocationContext = invocation.getInvocationContext();
        return invocationContext.getTargetBean();
    }
}

