/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework.deployment;

import org.jboss.wsf.common.integration.AbstractDeploymentAspect;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.LifecycleHandler;
import org.jboss.wsf.spi.deployment.Service;

public class EndpointLifecycleDeploymentAspect
extends AbstractDeploymentAspect {
    @Override
    public void start(Deployment dep) {
        for (Endpoint ep : dep.getService().getEndpoints()) {
            this.getLifecycleHandler(ep, true).start(ep);
        }
    }

    @Override
    public void stop(Deployment dep) {
        Service service = dep.getService();
        if (service != null) {
            for (Endpoint ep : service.getEndpoints()) {
                LifecycleHandler lifecycleHandler = this.getLifecycleHandler(ep, false);
                if (lifecycleHandler == null) continue;
                lifecycleHandler.stop(ep);
            }
        }
    }

    private LifecycleHandler getLifecycleHandler(Endpoint ep, boolean assertHandler) {
        LifecycleHandler lifecycleHandler = ep.getLifecycleHandler();
        if (lifecycleHandler == null && assertHandler) {
            throw new IllegalStateException("LifecycleHandler not initialised");
        }
        return lifecycleHandler;
    }
}

