/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.jboss.jaxb.intros.BindingCustomizationFactory;
import org.jboss.logging.Logger;
import org.jboss.wsf.common.integration.AbstractDeploymentAspect;
import org.jboss.wsf.spi.binding.BindingCustomization;
import org.jboss.wsf.spi.binding.JAXBBindingCustomization;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;

public class JAXBIntroDeploymentAspect
extends AbstractDeploymentAspect {
    private static Logger logger = Logger.getLogger(JAXBIntroDeploymentAspect.class);
    private static final String META_INF_JAXB_INTROS_XML = "META-INF/jaxb-intros.xml";
    private static final String WEB_INF_JAXB_INTROS_XML = "WEB-INF/jaxb-intros.xml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(Deployment deployment) {
        UnifiedVirtualFile vfs;
        if (!(deployment instanceof ArchiveDeployment)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("JAXBIntroDeploymentAspect doesn't work on " + deployment.getClass()));
            }
            return;
        }
        ArchiveDeployment archive = (ArchiveDeployment)deployment;
        InputStream introsConfigStream = null;
        try {
            vfs = archive.getRootFile().findChild(META_INF_JAXB_INTROS_XML);
            introsConfigStream = vfs.toURL().openStream();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (null == introsConfigStream) {
            try {
                vfs = archive.getRootFile().findChild(WEB_INF_JAXB_INTROS_XML);
                introsConfigStream = vfs.toURL().openStream();
            }
            catch (Exception e) {
                return;
            }
        }
        try {
            if (introsConfigStream != null) {
                JAXBBindingCustomization jaxbCustomizations = new JAXBBindingCustomization();
                BindingCustomizationFactory.populateBindingCustomization((InputStream)introsConfigStream, (Map)jaxbCustomizations);
                deployment.addAttachment(BindingCustomization.class, (Object)jaxbCustomizations);
                for (Endpoint endpoint : deployment.getService().getEndpoints()) {
                    endpoint.addAttachment(BindingCustomization.class, (Object)jaxbCustomizations);
                }
            }
        }
        finally {
            if (introsConfigStream != null) {
                try {
                    introsConfigStream.close();
                }
                catch (IOException e) {
                    logger.error((Object)("[" + deployment.getService().getContextRoot() + "] Error closing JAXB Introductions Configurations stream "), (Throwable)e);
                }
            }
        }
    }
}

