/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.tools.cmd;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

class SecurityActions {
    SecurityActions() {
    }

    static ClassLoader getContextClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static void setContextClassLoader(final ClassLoader classLoader) {
        if (System.getSecurityManager() == null) {
            Thread.currentThread().setContextClassLoader(classLoader);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    return null;
                }
            });
        }
    }

    static ClassLoader getModulesClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return SecurityActions.getModulesClassLoaderInternal();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return SecurityActions.getModulesClassLoaderInternal();
            }
        });
    }

    private static ClassLoader getModulesClassLoaderInternal() {
        try {
            Class<?> moduleClass = Class.forName("org.jboss.modules.Module");
            Class<?> moduleIdentifierClass = Class.forName("org.jboss.modules.ModuleIdentifier");
            Class<?> moduleLoaderClass = Class.forName("org.jboss.modules.ModuleLoader");
            Object moduleLoader = moduleClass.getMethod("getBootModuleLoader", new Class[0]).invoke(null, new Object[0]);
            Object moduleIdentifier = moduleIdentifierClass.getMethod("create", String.class).invoke(null, "org.jboss.as.webservices.server.integration");
            Object module = moduleLoaderClass.getMethod("loadModule", moduleIdentifierClass).invoke(moduleLoader, moduleIdentifier);
            return (ClassLoader)moduleClass.getMethod("getClassLoader", new Class[0]).invoke(module, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    static Class<?> loadClass(final ClassLoader cl, final String name) throws PrivilegedActionException, ClassNotFoundException {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return cl.loadClass(name);
        }
        return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

            @Override
            public Class<?> run() throws PrivilegedActionException {
                try {
                    return cl.loadClass(name);
                }
                catch (Exception e) {
                    throw new PrivilegedActionException(e);
                }
            }
        });
    }

    static String getSystemProperty(final String name, final String defaultValue) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return System.getProperty(name, defaultValue);
        }
        PrivilegedAction<String> action = new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(name, defaultValue);
            }
        };
        return AccessController.doPrivileged(action);
    }
}

