/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.deployment;

import java.util.LinkedList;
import java.util.List;
import org.jboss.wsf.spi.deployment.AbstractExtensible;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.EndpointTypeFilter;
import org.jboss.wsf.spi.deployment.Service;

public class DefaultService
extends AbstractExtensible
implements Service {
    private Deployment dep;
    private List<Endpoint> endpoints = new LinkedList<Endpoint>();
    private String contextRoot;
    private List<String> virtualHosts;

    DefaultService() {
    }

    public Deployment getDeployment() {
        return this.dep;
    }

    public void setDeployment(Deployment dep) {
        this.dep = dep;
    }

    public void addEndpoint(Endpoint endpoint) {
        endpoint.setService((Service)this);
        this.endpoints.add(endpoint);
    }

    public List<Endpoint> getEndpoints() {
        return this.endpoints;
    }

    public List<Endpoint> getEndpoints(EndpointTypeFilter filter) {
        LinkedList<Endpoint> result = new LinkedList<Endpoint>();
        for (Endpoint endpoint : this.endpoints) {
            if (!filter.accept(endpoint.getType())) continue;
            result.add(endpoint);
        }
        return result;
    }

    public Endpoint getEndpointByName(String shortName) {
        Endpoint retEndpoint = null;
        for (Endpoint ep : this.endpoints) {
            if (!ep.getShortName().equals(shortName)) continue;
            retEndpoint = ep;
            break;
        }
        return retEndpoint;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public void setContextRoot(String contextRoot) {
        this.contextRoot = contextRoot;
    }

    public List<String> getVirtualHosts() {
        if (this.virtualHosts != null) {
            LinkedList<String> retVal = new LinkedList<String>();
            for (String virtualHost : this.virtualHosts) {
                retVal.add(virtualHost);
            }
            return retVal;
        }
        return null;
    }

    public void setVirtualHosts(List<String> virtualHosts) {
        this.virtualHosts = virtualHosts;
    }
}

