/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.configuration;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.Handler;
import org.jboss.logging.Logger;
import org.jboss.ws.api.configuration.ClientConfigurer;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.configuration.SecurityActions;
import org.jboss.ws.common.utils.DelegateClassLoader;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;
import org.jboss.wsf.spi.metadata.config.ClientConfig;
import org.jboss.wsf.spi.metadata.config.CommonConfig;
import org.jboss.wsf.spi.metadata.config.ConfigMetaDataParser;
import org.jboss.wsf.spi.metadata.config.ConfigRoot;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;

public class ConfigHelper
implements ClientConfigurer {
    private static final ResourceBundle bundle = BundleUtils.getBundle(ConfigHelper.class);
    private static Map<String, String> bindingIDs = new HashMap<String, String>();

    public void addConfigHandlers(BindingProvider port, String configFile, String configName) {
        ClientConfig config = ConfigHelper.readConfig(configFile, configName);
        this.setupConfigHandlers(port.getBinding(), (CommonConfig)config);
    }

    private static ClientConfig readConfig(String configFile, String configName) {
        InputStream is = null;
        try {
            is = SecurityActions.getContextClassLoader().getResourceAsStream(configFile);
            ConfigRoot config = ConfigMetaDataParser.parse((InputStream)is);
            ClientConfig clientConfig = config.getClientConfigByName(configName);
            return clientConfig;
        }
        catch (Exception e) {
            throw new RuntimeException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"COULD_NOT_READ_CONFIG", (Object[])new Object[]{configFile}));
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void setupConfigHandlers(Binding binding, CommonConfig config) {
        if (config != null) {
            List<Handler> handlers = ConfigHelper.convertToHandlers(config.getPreHandlerChains(), binding);
            handlers.addAll(binding.getHandlerChain());
            handlers.addAll(ConfigHelper.convertToHandlers(config.getPostHandlerChains(), binding));
            binding.setHandlerChain(handlers);
        }
    }

    private static List<Handler> convertToHandlers(List<UnifiedHandlerChainMetaData> handlerChains, Binding binding) {
        LinkedList<Handler> handlers = new LinkedList<Handler>();
        if (handlerChains != null && !handlerChains.isEmpty()) {
            String protocolBinding = bindingIDs.get(binding.getBindingID());
            for (UnifiedHandlerChainMetaData handlerChain : handlerChains) {
                if (handlerChain.getPortNamePattern() != null || handlerChain.getServiceNamePattern() != null) {
                    Logger.getLogger(ConfigHelper.class).warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"FILTERS_NOT_SUPPORTED", (Object[])new Object[0]));
                }
                if (!ConfigHelper.matchProtocolBinding(protocolBinding, handlerChain.getProtocolBindings())) continue;
                for (UnifiedHandlerMetaData uhmd : handlerChain.getHandlers()) {
                    Object h;
                    if (uhmd.getInitParams() != null && !uhmd.getInitParams().isEmpty()) {
                        Logger.getLogger(ConfigHelper.class).warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"INIT_PARAMS_NOT_SUPPORTED", (Object[])new Object[0]));
                    }
                    if ((h = ConfigHelper.newInstance(uhmd.getHandlerClass())) == null) continue;
                    if (h instanceof Handler) {
                        handlers.add((Handler)h);
                        continue;
                    }
                    throw new RuntimeException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"NOT_HANDLER_INSTANCE", (Object[])new Object[]{h}));
                }
            }
        }
        return handlers;
    }

    private static boolean matchProtocolBinding(String currentProtocolBinding, String handlerChainProtocolBindings) {
        if (handlerChainProtocolBindings == null) {
            return true;
        }
        LinkedList<String> protocolBindings = new LinkedList<String>();
        if (handlerChainProtocolBindings != null) {
            StringTokenizer st = new StringTokenizer(handlerChainProtocolBindings, " ", false);
            while (st.hasMoreTokens()) {
                protocolBindings.add(st.nextToken());
            }
        }
        return protocolBindings.contains(currentProtocolBinding);
    }

    private static Object newInstance(String className) {
        try {
            DelegateClassLoader loader = new DelegateClassLoader(ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader(), SecurityActions.getContextClassLoader());
            Class<?> clazz = SecurityActions.loadClass(loader, className);
            return clazz.newInstance();
        }
        catch (Exception e) {
            Logger.getLogger(ConfigHelper.class).warnf((Throwable)e, BundleUtils.getMessage((ResourceBundle)bundle, (String)"CAN_NOT_ADD_HANDLER", (Object[])new Object[]{className}), new Object[0]);
            return null;
        }
    }

    static {
        bindingIDs.put("http://schemas.xmlsoap.org/wsdl/soap/http", "##SOAP11_HTTP");
        bindingIDs.put("http://www.w3.org/2003/05/soap/bindings/HTTP/", "##SOAP12_HTTP");
        bindingIDs.put("http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true", "##SOAP11_HTTP_MTOM");
        bindingIDs.put("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true", "##SOAP12_HTTP_MTOM");
        bindingIDs.put("http://www.w3.org/2004/08/wsdl/http", "##XML_HTTP");
    }
}

