/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.management;

import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.management.EndpointRegistry;
import org.jboss.wsf.spi.management.EndpointResolver;

public class DefaultEndpointRegistry
implements EndpointRegistry {
    private static final ResourceBundle bundle = BundleUtils.getBundle(DefaultEndpointRegistry.class);
    private static final Logger log = Logger.getLogger(DefaultEndpointRegistry.class);
    private Map<ObjectName, Endpoint> endpoints = new ConcurrentHashMap<ObjectName, Endpoint>();

    public Endpoint getEndpoint(ObjectName epName) {
        if (epName == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"ENDPOINT_NAME_CANNOT_BE_NULL", (Object[])new Object[0]));
        }
        if (!this.isRegistered(epName)) {
            throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"ENDPOINT_NOT_REGISTERED", (Object[])new Object[]{epName}));
        }
        Endpoint endpoint = this.endpoints.get(epName);
        return endpoint;
    }

    public Endpoint resolve(EndpointResolver resolver) {
        return resolver.query(this.endpoints.values().iterator());
    }

    public boolean isRegistered(ObjectName epName) {
        if (epName == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"ENDPOINT_NAME_CANNOT_BE_NULL", (Object[])new Object[0]));
        }
        return this.endpoints.get(epName) != null;
    }

    public Set<ObjectName> getEndpoints() {
        return this.endpoints.keySet();
    }

    public void register(Endpoint endpoint) {
        if (endpoint == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"ENDPOINT_CANNOT_BE_NULL", (Object[])new Object[0]));
        }
        ObjectName epName = endpoint.getName();
        if (epName == null) {
            throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"ENDPOINT_NAME_CANNOT_BE_NULL_FOR", (Object[])new Object[]{endpoint}));
        }
        if (this.isRegistered(epName)) {
            throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"ENDPOINT_ALREADY_REGISTERED", (Object[])new Object[]{epName}));
        }
        log.info((Object)("register: " + epName));
        this.endpoints.put(epName, endpoint);
    }

    public void unregister(Endpoint endpoint) {
        if (endpoint == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"ENDPOINT_CANNOT_BE_NULL", (Object[])new Object[0]));
        }
        ObjectName epName = endpoint.getName();
        if (!this.isRegistered(epName)) {
            throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"ENDPOINT_NOT_REGISTERED", (Object[])new Object[]{epName}));
        }
        log.info((Object)("remove: " + epName));
        this.endpoints.remove(epName);
    }
}

