/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.deployment;

import org.jboss.ws.common.Loggers;
import org.jboss.ws.common.Messages;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.EndpointState;
import org.jboss.wsf.spi.deployment.LifecycleHandler;
import org.jboss.wsf.spi.invocation.InvocationHandler;

public class DefaultLifecycleHandler
implements LifecycleHandler {
    public void start(Endpoint ep) {
        EndpointState state = ep.getState();
        if (state != EndpointState.UNDEFINED) {
            Loggers.DEPLOYMENT_LOGGER.cannotStartEndpoint(state, ep.getName());
        } else {
            InvocationHandler invHandler;
            if (ep.getEndpointMetrics() != null) {
                ep.getEndpointMetrics().start();
            }
            if ((invHandler = ep.getInvocationHandler()) == null) {
                throw Messages.MESSAGES.invocationHandlerNotAvailable(ep.getName());
            }
            invHandler.init(ep);
            ep.setState(EndpointState.STARTED);
        }
    }

    public void stop(Endpoint ep) {
        EndpointState state = ep.getState();
        if (state != EndpointState.STARTED) {
            Loggers.DEPLOYMENT_LOGGER.cannotStopEndpoint(state, ep.getName());
        } else {
            if (ep.getEndpointMetrics() != null) {
                ep.getEndpointMetrics().stop();
            }
            ep.setState(EndpointState.STOPPED);
        }
    }
}

