/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.deployment;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import org.jboss.ws.common.Loggers;
import org.jboss.ws.common.Messages;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.ResourceResolver;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;

public class ResourceResolverImpl
implements ResourceResolver {
    private final UnifiedVirtualFile rootFile;
    private final Collection<UnifiedVirtualFile> metadataFiles;
    private final ArchiveDeployment deployment;

    public ResourceResolverImpl(ArchiveDeployment deployment) {
        this.deployment = deployment;
        this.rootFile = deployment.getRootFile();
        this.metadataFiles = deployment.getMetadataFiles();
    }

    public URL resolve(String resourcePath) throws IOException {
        URL resourceURL = null;
        if (resourcePath != null && resourcePath.length() > 0) {
            UnifiedVirtualFile vfResource;
            if (resourcePath.startsWith("/")) {
                resourcePath = resourcePath.substring(1);
            }
            try {
                resourceURL = new URL(resourcePath);
            }
            catch (MalformedURLException ex) {
                // empty catch block
            }
            if (resourceURL == null && this.rootFile != null) {
                try {
                    vfResource = this.rootFile.findChild(resourcePath);
                    resourceURL = vfResource.toURL();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (resourceURL == null && this.metadataFiles != null && !this.metadataFiles.isEmpty()) {
                Loggers.ROOT_LOGGER.cannotGetRootFileTryingWithAdditionalMetaData(resourcePath);
                vfResource = null;
                Iterator<UnifiedVirtualFile> it = this.metadataFiles.iterator();
                while (it.hasNext() && vfResource == null) {
                    UnifiedVirtualFile uvf = it.next();
                    URL wsdlUrl = uvf.toURL();
                    String wsdlPath = wsdlUrl.getPath();
                    if (wsdlPath.startsWith("/")) {
                        wsdlPath = wsdlPath.substring(1);
                    }
                    if (resourcePath.equals(wsdlPath)) {
                        vfResource = uvf;
                        continue;
                    }
                    try {
                        vfResource = uvf.findChild(resourcePath);
                    }
                    catch (IOException e) {
                        Loggers.ROOT_LOGGER.cannotGetRootResourceFrom(resourcePath, uvf, e);
                    }
                }
                if (vfResource != null) {
                    resourceURL = vfResource.toURL();
                }
            }
            if (resourceURL == null && this.deployment.getRuntimeClassLoader() != null) {
                resourceURL = this.deployment.getRuntimeClassLoader().getResource(resourcePath);
            }
            if (resourceURL == null && this.deployment.getInitialClassLoader() != null) {
                resourceURL = this.deployment.getInitialClassLoader().getResource(resourcePath);
            }
            if (resourceURL == null) {
                throw Messages.MESSAGES.cannotResolveResource(resourcePath, this.deployment.getSimpleName());
            }
        }
        return resourceURL;
    }

    public URL resolveFailSafe(String resourcePath) {
        boolean traceEnabled = Loggers.ROOT_LOGGER.isTraceEnabled();
        URL resourceURL = null;
        if (resourcePath != null && resourcePath.length() > 0) {
            UnifiedVirtualFile vfResource;
            if (resourcePath.startsWith("/")) {
                resourcePath = resourcePath.substring(1);
            }
            try {
                resourceURL = new URL(resourcePath);
            }
            catch (MalformedURLException ex) {
                // empty catch block
            }
            if (resourceURL == null && this.rootFile != null) {
                vfResource = this.rootFile.findChildFailSafe(resourcePath);
                if (vfResource == null) {
                    if (this.metadataFiles == null || this.metadataFiles.isEmpty()) {
                        if (traceEnabled) {
                            Loggers.ROOT_LOGGER.cannotGetRootResourceFrom(resourcePath, this.rootFile, null);
                        }
                    } else if (traceEnabled) {
                        Loggers.ROOT_LOGGER.cannotGetRootFileTryingWithAdditionalMetaData(resourcePath);
                    }
                } else {
                    resourceURL = vfResource.toURL();
                }
            }
            if (resourceURL == null && this.metadataFiles != null && !this.metadataFiles.isEmpty()) {
                vfResource = null;
                Iterator<UnifiedVirtualFile> it = this.metadataFiles.iterator();
                while (it.hasNext() && vfResource == null) {
                    UnifiedVirtualFile uvf = it.next();
                    URL wsdlUrl = uvf.toURL();
                    String wsdlPath = wsdlUrl.getPath();
                    if (wsdlPath.startsWith("/")) {
                        wsdlPath = wsdlPath.substring(1);
                    }
                    if (resourcePath.equals(wsdlPath)) {
                        vfResource = uvf;
                        continue;
                    }
                    vfResource = uvf.findChildFailSafe(resourcePath);
                    if (!traceEnabled || vfResource != null) continue;
                    Loggers.ROOT_LOGGER.cannotGetRootResourceFrom(resourcePath, uvf, null);
                }
                if (vfResource == null) {
                    if (traceEnabled) {
                        Loggers.ROOT_LOGGER.cannotFindInAdditionalMetaData(resourcePath);
                    }
                } else {
                    resourceURL = vfResource.toURL();
                }
            }
        }
        return resourceURL;
    }
}

