/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.management;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import javax.management.MBeanServer;
import org.jboss.ws.common.Loggers;
import org.jboss.ws.common.Messages;
import org.jboss.ws.common.management.AbstractServerConfigMBean;
import org.jboss.ws.common.management.CommonConfigStoreImpl;
import org.jboss.ws.common.utils.AddressUtils;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.WSFException;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;
import org.jboss.wsf.spi.management.CommonConfigStore;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.management.StackConfig;
import org.jboss.wsf.spi.management.StackConfigFactory;
import org.jboss.wsf.spi.management.WebServerInfo;
import org.jboss.wsf.spi.management.WebServerInfoFactory;
import org.jboss.wsf.spi.metadata.config.AbstractCommonConfig;
import org.jboss.wsf.spi.metadata.config.ClientConfig;
import org.jboss.wsf.spi.metadata.config.EndpointConfig;

public abstract class AbstractServerConfig
implements AbstractServerConfigMBean,
ServerConfig {
    private static final RuntimePermission LOOKUP_SERVER_INTEGRATION_SERVER_CONFIG = new RuntimePermission("org.jboss.ws.LOOKUP_SERVER_INTEGRATION_SERVER_CONFIG");
    private volatile MBeanServer mbeanServer;
    private volatile String webServiceHost = "jbossws.undefined.host";
    private final Object webServiceHostLock = new Object();
    private int webServicePort;
    private final Object webServicePortLock = new Object();
    private int webServiceSecurePort;
    private final Object webServiceSecurePortLock = new Object();
    private volatile boolean modifySOAPAddress;
    private final Object modifySOAPAddressLock = new Object();
    private volatile String webServicePathRewriteRule;
    private final Object webServicePathRewriteRuleLock = new Object();
    private volatile String webServiceUriScheme;
    private final Object webServiceUriSchemeLock = new Object();
    private volatile boolean statisticsEnabled;
    protected volatile StackConfig stackConfig;
    protected final CommonConfigStore<ClientConfig> clientConfigStore = new CommonConfigStoreImpl<ClientConfig>();
    protected final CommonConfigStore<EndpointConfig> endpointConfigStore = new CommonConfigStoreImpl<EndpointConfig>();
    private static volatile ServerConfig serverConfig;
    public static final PrivilegedAction<ServerConfig> GET_SERVER_INTEGRATION_SERVER_CONFIG;

    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    @Override
    public String getWebServiceHost() {
        return this.webServiceHost;
    }

    @Override
    public void setWebServiceHost(String host) throws UnknownHostException {
        this.setWebServiceHost(host, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setWebServiceHost(String host, UpdateCallbackHandler uch) throws UnknownHostException {
        if (host == null || host.trim().length() == 0) {
            Loggers.MANAGEMENT_LOGGER.usingUndefinedWebServicesHost("jbossws.undefined.host");
            host = "jbossws.undefined.host";
        }
        if ("0.0.0.0".equals(host)) {
            InetAddress localHost = InetAddress.getLocalHost();
            if (Loggers.MANAGEMENT_LOGGER.isDebugEnabled()) {
                Loggers.MANAGEMENT_LOGGER.usingLocalHostWebServicesHost(localHost.getHostName());
            }
            host = localHost.getHostName();
        }
        String wsh = this.toIPv6URLFormat("127.0.0.1".equals(host) ? "localhost" : host);
        Object object = this.webServiceHostLock;
        synchronized (object) {
            if (uch != null) {
                uch.onBeforeUpdate();
            }
            this.webServiceHost = wsh;
        }
    }

    private String toIPv6URLFormat(String host) {
        String address = host;
        boolean isIPv6URLFormatted = false;
        if (host.startsWith("[") && host.endsWith("]")) {
            isIPv6URLFormatted = true;
            address = host.substring(1, host.length() - 1);
        }
        if (!AddressUtils.isValidAddress(address)) {
            throw Messages.MESSAGES.invalidAddressProvided(address);
        }
        if (isIPv6URLFormatted) {
            return host;
        }
        return AddressUtils.isValidIPv6Address(host) ? "[" + host + "]" : host;
    }

    @Override
    public void setWebServicePort(int port) {
        this.setWebServicePort(port, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setWebServicePort(int port, UpdateCallbackHandler uch) {
        Object object = this.webServicePortLock;
        synchronized (object) {
            if (uch != null) {
                uch.onBeforeUpdate();
            }
            this.webServicePort = port;
        }
    }

    @Override
    public void setWebServiceSecurePort(int port) {
        this.setWebServiceSecurePort(port, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setWebServiceSecurePort(int port, UpdateCallbackHandler uch) {
        Object object = this.webServiceSecurePortLock;
        synchronized (object) {
            if (uch != null) {
                uch.onBeforeUpdate();
            }
            this.webServiceSecurePort = port;
        }
    }

    @Override
    public boolean isModifySOAPAddress() {
        return this.modifySOAPAddress;
    }

    @Override
    public void setModifySOAPAddress(boolean modify) {
        this.modifySOAPAddress = modify;
    }

    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public void setStatisticsEnabled(boolean enabled) {
        this.statisticsEnabled = enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setModifySOAPAddress(boolean modify, UpdateCallbackHandler uch) {
        Object object = this.modifySOAPAddressLock;
        synchronized (object) {
            if (uch != null) {
                uch.onBeforeUpdate();
            }
            this.modifySOAPAddress = modify;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getWebServicePort() {
        Object object = this.webServicePortLock;
        synchronized (object) {
            int localPort;
            if (this.webServicePort <= 0) {
                this.webServicePort = this.getConnectorPort(false);
            }
            if ((localPort = this.webServicePort) <= 0) {
                if (Loggers.MANAGEMENT_LOGGER.isDebugEnabled()) {
                    Loggers.MANAGEMENT_LOGGER.unableToCalculateWebServicesPort("8080");
                }
                localPort = 8080;
            }
            return localPort;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getWebServiceSecurePort() {
        Object object = this.webServiceSecurePortLock;
        synchronized (object) {
            int localPort;
            int connectorPort;
            if (this.webServiceSecurePort <= 0 && (connectorPort = this.getConnectorPort(true)) > 0 && connectorPort != this.getConnectorPort(false)) {
                this.webServiceSecurePort = connectorPort;
            }
            if ((localPort = this.webServiceSecurePort) <= 0) {
                if (Loggers.MANAGEMENT_LOGGER.isDebugEnabled()) {
                    Loggers.MANAGEMENT_LOGGER.unableToCalculateWebServicesSecurePort("8443");
                }
                localPort = 8443;
            }
            return localPort;
        }
    }

    @Override
    public String getWebServicePathRewriteRule() {
        return this.webServicePathRewriteRule;
    }

    @Override
    public void setWebServicePathRewriteRule(String path) {
        this.setWebServicePathRewriteRule(path, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWebServicePathRewriteRule(String path, UpdateCallbackHandler uch) {
        Object object = this.webServicePathRewriteRuleLock;
        synchronized (object) {
            if (uch != null) {
                uch.onBeforeUpdate();
            }
            this.webServicePathRewriteRule = path;
        }
    }

    @Override
    public String getWebServiceUriScheme() {
        return this.webServiceUriScheme;
    }

    @Override
    public void setWebServiceUriScheme(String scheme) {
        this.setWebServiceUriScheme(scheme, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWebServiceUriScheme(String scheme, UpdateCallbackHandler uch) {
        Object object = this.webServiceUriSchemeLock;
        synchronized (object) {
            if (uch != null) {
                uch.onBeforeUpdate();
            }
            this.webServiceUriScheme = scheme;
        }
    }

    private int getConnectorPort(boolean secure) {
        ClassLoader cl = ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader();
        int port = 0;
        try {
            WebServerInfo webServerInfo = ((WebServerInfoFactory)SPIProvider.getInstance().getSPI(WebServerInfoFactory.class, cl)).newWebServerInfo();
            port = webServerInfo.getPort("HTTP/1.1", secure);
        }
        catch (WSFException e) {
            Loggers.MANAGEMENT_LOGGER.couldNotGetPortFromConfiguredHTTPConnector();
        }
        return port;
    }

    public void create() throws Exception {
        ClassLoader cl = ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader();
        this.stackConfig = ((StackConfigFactory)SPIProvider.getInstance().getSPI(StackConfigFactory.class, cl)).getStackConfig();
        Loggers.MANAGEMENT_LOGGER.startingWSServerConfig(this.getImplementationTitle(), this.getImplementationVersion());
        MBeanServer mbeanServer = this.getMbeanServer();
        if (mbeanServer != null) {
            mbeanServer.registerMBean(this, AbstractServerConfigMBean.OBJECT_NAME);
        }
        this.clientConfigStore.reload();
        this.endpointConfigStore.reload();
        if (ClassLoaderProvider.isSet()) {
            serverConfig = this;
        }
    }

    public void destroy() throws Exception {
        MBeanServer mbeanServer = this.getMbeanServer();
        if (mbeanServer != null) {
            mbeanServer.unregisterMBean(AbstractServerConfigMBean.OBJECT_NAME);
        }
        this.clientConfigStore.unload();
        this.endpointConfigStore.unload();
    }

    public static ServerConfig getServerIntegrationServerConfig() {
        if (!ClassLoaderProvider.isSet()) {
            return null;
        }
        AbstractServerConfig.checkPermission(LOOKUP_SERVER_INTEGRATION_SERVER_CONFIG);
        return serverConfig;
    }

    @Override
    public String getImplementationTitle() {
        return this.stackConfig.getImplementationTitle();
    }

    @Override
    public String getImplementationVersion() {
        return this.stackConfig.getImplementationVersion();
    }

    public void registerClientConfig(ClientConfig config) {
        this.clientConfigStore.register((AbstractCommonConfig)config);
    }

    public void unregisterClientConfig(ClientConfig config) {
        this.clientConfigStore.unregister((AbstractCommonConfig)config);
    }

    public void reloadClientConfigs() {
        this.clientConfigStore.reload();
    }

    public ClientConfig getClientConfig(String name) {
        return (ClientConfig)this.clientConfigStore.getConfig(name);
    }

    public void registerEndpointConfig(EndpointConfig config) {
        this.endpointConfigStore.register((AbstractCommonConfig)config);
    }

    public void unregisterEndpointConfig(EndpointConfig config) {
        this.endpointConfigStore.unregister((AbstractCommonConfig)config);
    }

    public void reloadEndpointConfigs() {
        this.endpointConfigStore.reload();
    }

    public EndpointConfig getEndpointConfig(String name) {
        return (EndpointConfig)this.endpointConfigStore.getConfig(name);
    }

    private static void checkPermission(Permission permission) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            AccessController.checkPermission(permission);
        }
    }

    static {
        GET_SERVER_INTEGRATION_SERVER_CONFIG = new PrivilegedAction<ServerConfig>(){

            @Override
            public ServerConfig run() {
                return AbstractServerConfig.getServerIntegrationServerConfig();
            }
        };
    }

    public static interface UpdateCallbackHandler {
        public void onBeforeUpdate();
    }
}

