/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.util.xml.JBossEntityResolver;
import org.jboss.ws.common.Loggers;
import org.jboss.ws.common.Messages;
import org.jboss.ws.common.utils.DelegateClassLoader;
import org.jboss.ws.common.utils.ResourceURL;
import org.jboss.ws.common.utils.SecurityActions;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JBossWSEntityResolver
extends JBossEntityResolver {
    private static final Map<ClassLoader, Map<String, Properties>> propertiesMap = Collections.synchronizedMap(new WeakHashMap());
    private final ClassLoader additionalClassLoader;

    public JBossWSEntityResolver() {
        this(ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader());
    }

    public JBossWSEntityResolver(ClassLoader loader) {
        this("META-INF/jbossws-entities.properties", loader);
    }

    public JBossWSEntityResolver(String entitiesResource) {
        this(entitiesResource, ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader());
    }

    public JBossWSEntityResolver(String entitiesResource, ClassLoader loader) {
        this.additionalClassLoader = loader;
        Properties props = null;
        ClassLoader tccl = SecurityActions.getContextClassLoader();
        Map<String, Properties> map = propertiesMap.get(tccl);
        if (map != null && map.containsKey(entitiesResource)) {
            props = map.get(entitiesResource);
        } else {
            if (map == null) {
                map = new ConcurrentHashMap<String, Properties>();
                propertiesMap.put(tccl, map);
            }
            if ((props = this.loadEntitiesMappingFromClasspath(entitiesResource, tccl, this.additionalClassLoader)).size() == 0) {
                throw Messages.MESSAGES.entityResolutionNoEntityMapppingDefined(entitiesResource);
            }
            map.put(entitiesResource, props);
        }
        String key = null;
        String val = null;
        Enumeration<Object> keys = props.keys();
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            val = props.getProperty(key);
            JBossWSEntityResolver.registerEntity((String)key, (String)val);
        }
    }

    private Properties loadEntitiesMappingFromClasspath(final String entitiesResource, final ClassLoader classLoader, final ClassLoader additionalClassLoader) {
        return AccessController.doPrivileged(new PrivilegedAction<Properties>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Properties run() {
                InputStream is = new DelegateClassLoader(additionalClassLoader, classLoader).getResourceAsStream(entitiesResource);
                if (is == null) {
                    throw Messages.MESSAGES.entityResolutionResourceNotFound(entitiesResource);
                }
                Properties props = new Properties();
                try {
                    props.load(is);
                }
                catch (IOException ioe) {
                    Loggers.ROOT_LOGGER.cannotReadResource(entitiesResource, ioe);
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                return props;
            }
        });
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource inputSource;
        if (Loggers.ROOT_LOGGER.isTraceEnabled()) {
            Loggers.ROOT_LOGGER.trace(((Object)((Object)this)).getClass().getName(), "resolveEntity: [pub=" + publicId + ",sysid=" + systemId + "]", null);
        }
        if ((inputSource = super.resolveEntity(publicId, systemId)) == null) {
            inputSource = this.resolveSystemIDAsURL(systemId, Loggers.ROOT_LOGGER.isTraceEnabled());
        }
        if (inputSource == null && Loggers.ROOT_LOGGER.isDebugEnabled()) {
            Loggers.ROOT_LOGGER.debug(((Object)((Object)this)).getClass().getName(), "Cannot resolve entity: [pub=" + publicId + ",sysid=" + systemId + "]", null);
        }
        return inputSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream loadClasspathResource(String resource, boolean trace) {
        InputStream is = super.loadClasspathResource(resource, trace);
        if (is == null) {
            ClassLoader origLoader = SecurityActions.getContextClassLoader();
            try {
                SecurityActions.setContextClassLoader(this.additionalClassLoader);
                is = super.loadClasspathResource(resource, trace);
            }
            finally {
                SecurityActions.setContextClassLoader(origLoader);
            }
        }
        return is;
    }

    protected InputSource resolveSystemIDAsURL(String id, boolean trace) {
        InputSource inputSource;
        block10: {
            if (id == null) {
                return null;
            }
            if (trace) {
                Loggers.ROOT_LOGGER.trace(((Object)((Object)this)).getClass().getName(), "resolveIDAsResourceURL, id=" + id, null);
            }
            inputSource = null;
            try {
                URL url;
                InputStream ins;
                if (trace) {
                    Loggers.ROOT_LOGGER.trace(((Object)((Object)this)).getClass().getName(), "Trying to resolve id as a URL", null);
                }
                if ((ins = new ResourceURL(url = new URL(id)).openStream()) != null) {
                    inputSource = new InputSource(ins);
                    inputSource.setSystemId(id);
                } else {
                    Loggers.ROOT_LOGGER.cannotLoadIDAsURL(id, url.getProtocol());
                }
                if (trace) {
                    Loggers.ROOT_LOGGER.trace(((Object)((Object)this)).getClass().getName(), "Resolved id as a URL", null);
                }
            }
            catch (MalformedURLException ignored) {
                if (trace) {
                    Loggers.ROOT_LOGGER.trace(((Object)((Object)this)).getClass().getName(), "id is not a url: " + id, ignored);
                }
            }
            catch (IOException e) {
                if (!trace) break block10;
                Loggers.ROOT_LOGGER.trace(((Object)((Object)this)).getClass().getName(), "Failed to obtain URL.InputStream from id: " + id, e);
            }
        }
        return inputSource;
    }
}

