package org.jboss.ws.common;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import org.jboss.logging.Logger;
import java.net.URL;
import javax.management.ObjectName;
import org.jboss.wsf.spi.deployment.EndpointState;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.ClassLoader;
import java.lang.Object;


import static org.jboss.logging.Logger.Level.TRACE;
import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2018-05-10T08:24:29-0400")
public class Loggers_$logger extends DelegatingBasicLogger implements Loggers, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Loggers_$logger.class.getName();
    public Loggers_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void cannotGetChildrenForResource(final Throwable cause, final URL url) {
        super.log.logf(FQCN, ERROR, cause, cannotGetChildrenForResource$str(), url);
    }
    private static final String cannotGetChildrenForResource = "JBWS022001: Cannot get children for resource %s";
    protected String cannotGetChildrenForResource$str() {
        return cannotGetChildrenForResource;
    }
    @Override
    public final void cannotGetNameForResource(final Throwable cause, final URL url) {
        super.log.logf(FQCN, ERROR, cause, cannotGetNameForResource$str(), url);
    }
    private static final String cannotGetNameForResource = "JBWS022002: Cannot get name for resource %s";
    protected String cannotGetNameForResource$str() {
        return cannotGetNameForResource;
    }
    @Override
    public final void notAssignableDueToConflictingClassLoaders(final Class<?> dest, final Class<?> src, final ClassLoader destClassLoader, final ClassLoader srcClassLoader) {
        super.log.logf(FQCN, TRACE, null, notAssignableDueToConflictingClassLoaders$str(), dest, src, destClassLoader, srcClassLoader);
    }
    private static final String notAssignableDueToConflictingClassLoaders = "JBWS022010: Class %s is not assignable from %s due to conflicting classloaders: %s and %s";
    protected String notAssignableDueToConflictingClassLoaders$str() {
        return notAssignableDueToConflictingClassLoaders;
    }
    @Override
    public final void couldNotClearBlacklist(final ClassLoader cl, final Throwable cause) {
        super.log.logf(FQCN, TRACE, cause, couldNotClearBlacklist$str(), cl);
    }
    private static final String couldNotClearBlacklist = "JBWS022011: Could not clear blacklist for classloader %s";
    protected String couldNotClearBlacklist$str() {
        return couldNotClearBlacklist;
    }
    @Override
    public final void couldNotLoad(final String className) {
        super.log.logf(FQCN, DEBUG, null, couldNotLoad$str(), className);
    }
    private static final String couldNotLoad = "JBWS022012: Could not load %s";
    protected String couldNotLoad$str() {
        return couldNotLoad;
    }
    @Override
    public final void cannotParse(final String s) {
        super.log.logf(FQCN, ERROR, null, cannotParse$str(), s);
    }
    private static final String cannotParse = "JBWS022013: Cannot parse: %s";
    protected String cannotParse$str() {
        return cannotParse;
    }
    @Override
    public final void cannotReadResource(final String s, final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, cannotReadResource$str(), s);
    }
    private static final String cannotReadResource = "JBWS022021: Cannot read resource: %s";
    protected String cannotReadResource$str() {
        return cannotReadResource;
    }
    @Override
    public final void cannotLoadIDAsURL(final String id, final String protocol) {
        super.log.logf(FQCN, WARN, null, cannotLoadIDAsURL$str(), id, protocol);
    }
    private static final String cannotLoadIDAsURL = "JBWS022022: Cannot load ID '%s' as URL (protocol = %s)";
    protected String cannotLoadIDAsURL$str() {
        return cannotLoadIDAsURL;
    }
    @Override
    public final void wsdlImportPublishedTo(final URL url) {
        super.log.logf(FQCN, DEBUG, null, wsdlImportPublishedTo$str(), url);
    }
    private static final String wsdlImportPublishedTo = "JBWS022025: WSDL import published to %s";
    protected String wsdlImportPublishedTo$str() {
        return wsdlImportPublishedTo;
    }
    @Override
    public final void xmlSchemaImportPublishedTo(final URL url) {
        super.log.logf(FQCN, DEBUG, null, xmlSchemaImportPublishedTo$str(), url);
    }
    private static final String xmlSchemaImportPublishedTo = "JBWS022026: XMLSchema import published to %s";
    protected String xmlSchemaImportPublishedTo$str() {
        return xmlSchemaImportPublishedTo;
    }
    @Override
    public final void cannotDeletePublishedWsdlDoc(final URL url) {
        super.log.logf(FQCN, WARN, null, cannotDeletePublishedWsdlDoc$str(), url);
    }
    private static final String cannotDeletePublishedWsdlDoc = "JBWS022027: Cannot delete published wsdl document: %s";
    protected String cannotDeletePublishedWsdlDoc$str() {
        return cannotDeletePublishedWsdlDoc;
    }
    @Override
    public final void cannotRegisterProvidedProcessor(final ObjectName processorName, final Throwable cause) {
        super.log.logf(FQCN, DEBUG, cause, cannotRegisterProvidedProcessor$str(), processorName);
    }
    private static final String cannotRegisterProvidedProcessor = "JBWS022042: Cannot register processor %s with JMX server, will be trying using the default managed implementation. ";
    protected String cannotRegisterProvidedProcessor$str() {
        return cannotRegisterProvidedProcessor;
    }
    @Override
    public final void cannotRegisterProcessorWithJmxServer(final ObjectName processorName, final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, cannotRegisterProcessorWithJmxServer$str(), processorName);
    }
    private static final String cannotRegisterProcessorWithJmxServer = "JBWS022043: Cannot register processor %s with JMX server";
    protected String cannotRegisterProcessorWithJmxServer$str() {
        return cannotRegisterProcessorWithJmxServer;
    }
    @Override
    public final void cannotUnregisterProcessorWithJmxServer(final ObjectName processorName, final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, cannotUnregisterProcessorWithJmxServer$str(), processorName);
    }
    private static final String cannotUnregisterProcessorWithJmxServer = "JBWS022044: Cannot unregister processor %s with JMX server";
    protected String cannotUnregisterProcessorWithJmxServer$str() {
        return cannotUnregisterProcessorWithJmxServer;
    }
    @Override
    public final void startingWSServerConfig(final String implTitle, final String implVersion) {
        super.log.logf(FQCN, INFO, null, startingWSServerConfig$str(), implTitle, implVersion);
    }
    private static final String startingWSServerConfig = "JBWS022052: Starting %s %s";
    protected String startingWSServerConfig$str() {
        return startingWSServerConfig;
    }
    @Override
    public final void unableToCalculateWebServicesPort(final String def) {
        super.log.logf(FQCN, DEBUG, null, unableToCalculateWebServicesPort$str(), def);
    }
    private static final String unableToCalculateWebServicesPort = "JBWS022053: Unable to calculate webservices port, using default %s";
    protected String unableToCalculateWebServicesPort$str() {
        return unableToCalculateWebServicesPort;
    }
    @Override
    public final void unableToCalculateWebServicesSecurePort(final String def) {
        super.log.logf(FQCN, DEBUG, null, unableToCalculateWebServicesSecurePort$str(), def);
    }
    private static final String unableToCalculateWebServicesSecurePort = "JBWS022054: Unable to calculate webservices secure port, using default %s";
    protected String unableToCalculateWebServicesSecurePort$str() {
        return unableToCalculateWebServicesSecurePort;
    }
    @Override
    public final void usingUndefinedWebServicesHost(final String host) {
        super.log.logf(FQCN, DEBUG, null, usingUndefinedWebServicesHost$str(), host);
    }
    private static final String usingUndefinedWebServicesHost = "JBWS022055: Using undefined webservices host: %s";
    protected String usingUndefinedWebServicesHost$str() {
        return usingUndefinedWebServicesHost;
    }
    @Override
    public final void usingLocalHostWebServicesHost(final String host) {
        super.log.logf(FQCN, DEBUG, null, usingLocalHostWebServicesHost$str(), host);
    }
    private static final String usingLocalHostWebServicesHost = "JBWS022056: Setting webservices host to localhost: %s";
    protected String usingLocalHostWebServicesHost$str() {
        return usingLocalHostWebServicesHost;
    }
    @Override
    public final void couldNotGetAddressForHost(final String host, final Throwable cause) {
        super.log.logf(FQCN, DEBUG, cause, couldNotGetAddressForHost$str(), host);
    }
    private static final String couldNotGetAddressForHost = "JBWS022057: Could not get address for host: %s";
    protected String couldNotGetAddressForHost$str() {
        return couldNotGetAddressForHost;
    }
    @Override
    public final void couldNotGetPortFromConfiguredHTTPConnector() {
        super.log.logf(FQCN, WARN, null, couldNotGetPortFromConfiguredHTTPConnector$str());
    }
    private static final String couldNotGetPortFromConfiguredHTTPConnector = "JBWS022058: Could not get port for webservices configuration from configured HTTP connector";
    protected String couldNotGetPortFromConfiguredHTTPConnector$str() {
        return couldNotGetPortFromConfiguredHTTPConnector;
    }
    @Override
    public final void unableToReadFromHttpServletRequest(final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, unableToReadFromHttpServletRequest$str());
    }
    private static final String unableToReadFromHttpServletRequest = "JBWS022059: Unable to read from the http servlet request";
    protected String unableToReadFromHttpServletRequest$str() {
        return unableToReadFromHttpServletRequest;
    }
    @Override
    public final void cannotTraceSoapMessage(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, cannotTraceSoapMessage$str());
    }
    private static final String cannotTraceSoapMessage = "JBWS022060: Cannot trace SOAP message";
    protected String cannotTraceSoapMessage$str() {
        return cannotTraceSoapMessage;
    }
    @Override
    public final void methodInvocationFailed(final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, methodInvocationFailed$str());
    }
    private static final String methodInvocationFailed = "JBWS022061: Method invocation failed with exception";
    protected String methodInvocationFailed$str() {
        return methodInvocationFailed;
    }
    @Override
    public final void cannotGetRootFileTryingWithAdditionalMetaData(final String resourcePath) {
        super.log.logf(FQCN, TRACE, null, cannotGetRootFileTryingWithAdditionalMetaData$str(), resourcePath);
    }
    private static final String cannotGetRootFileTryingWithAdditionalMetaData = "JBWS022090: Cannot get %s from root file, trying with additional metadata files";
    protected String cannotGetRootFileTryingWithAdditionalMetaData$str() {
        return cannotGetRootFileTryingWithAdditionalMetaData;
    }
    @Override
    public final void cannotGetRootResourceFrom(final String resourcePath, final Object uvf, final Throwable cause) {
        super.log.logf(FQCN, TRACE, cause, cannotGetRootResourceFrom$str(), resourcePath, uvf);
    }
    private static final String cannotGetRootResourceFrom = "JBWS022098: Cannot get %s from %s";
    protected String cannotGetRootResourceFrom$str() {
        return cannotGetRootResourceFrom;
    }
    @Override
    public final void errorDuringDeployment(final String dep, final Throwable cause) {
        super.log.logf(FQCN, DEBUG, cause, errorDuringDeployment$str(), dep);
    }
    private static final String errorDuringDeployment = "JBWS022099: Error during deployment: %s";
    protected String errorDuringDeployment$str() {
        return errorDuringDeployment;
    }
    @Override
    public final void errorDestroyingDeployment(final String dep, final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, errorDestroyingDeployment$str(), dep);
    }
    private static final String errorDestroyingDeployment = "JBWS022100: Error while destroying deployment %s due to previous exception";
    protected String errorDestroyingDeployment$str() {
        return errorDestroyingDeployment;
    }
    @Override
    public final void cannotStopEndpoint(final EndpointState state, final ObjectName epName) {
        super.log.logf(FQCN, ERROR, null, cannotStopEndpoint$str(), state, epName);
    }
    private static final String cannotStopEndpoint = "JBWS022102: Cannot stop endpoint in state %s: %s";
    protected String cannotStopEndpoint$str() {
        return cannotStopEndpoint;
    }
    @Override
    public final void cannotStartEndpoint(final EndpointState state, final ObjectName epName) {
        super.log.logf(FQCN, ERROR, null, cannotStartEndpoint$str(), state, epName);
    }
    private static final String cannotStartEndpoint = "JBWS022103: Cannot start endpoint in state %s: %s";
    protected String cannotStartEndpoint$str() {
        return cannotStartEndpoint;
    }
    @Override
    public final void cannotAddHandler(final String className, final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, cannotAddHandler$str(), className);
    }
    private static final String cannotAddHandler = "JBWS022110: Could not add handler %s as part of client or endpoint configuration";
    protected String cannotAddHandler$str() {
        return cannotAddHandler;
    }
    @Override
    public final void filtersNotSupported() {
        super.log.logf(FQCN, WARN, null, filtersNotSupported$str());
    }
    private static final String filtersNotSupported = "JBWS022111: PortNamePattern and ServiceNamePattern filters not supported; adding handlers anyway";
    protected String filtersNotSupported$str() {
        return filtersNotSupported;
    }
    @Override
    public final void initParamsNotSupported() {
        super.log.logf(FQCN, WARN, null, initParamsNotSupported$str());
    }
    private static final String initParamsNotSupported = "JBWS022112: Init params not supported; adding handler anyway";
    protected String initParamsNotSupported$str() {
        return initParamsNotSupported;
    }
    @Override
    public final void errorClosingJAXBIntroConf(final URL url, final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, errorClosingJAXBIntroConf$str(), url);
    }
    private static final String errorClosingJAXBIntroConf = "JBWS022113: Error closing JAXBIntro configuration stream: %s";
    protected String errorClosingJAXBIntroConf$str() {
        return errorClosingJAXBIntroConf;
    }
    @Override
    public final void aspectDoesNotWorkOnDeployment(final Class<?> aspect, final Class<?> deployment) {
        super.log.logf(FQCN, TRACE, null, aspectDoesNotWorkOnDeployment$str(), aspect, deployment);
    }
    private static final String aspectDoesNotWorkOnDeployment = "JBWS022114: %s doesn't work on %s";
    protected String aspectDoesNotWorkOnDeployment$str() {
        return aspectDoesNotWorkOnDeployment;
    }
    @Override
    public final void cannotGetURLFor(final String path) {
        super.log.logf(FQCN, TRACE, null, cannotGetURLFor$str(), path);
    }
    private static final String cannotGetURLFor = "JBWS022115: Cannot get URL for %s";
    protected String cannotGetURLFor$str() {
        return cannotGetURLFor;
    }
    @Override
    public final void cannotFindInAdditionalMetaData(final String resourcePath) {
        super.log.logf(FQCN, TRACE, null, cannotFindInAdditionalMetaData$str(), resourcePath);
    }
    private static final String cannotFindInAdditionalMetaData = "JBWS022116: Could not find %s in the additional metadatafiles";
    protected String cannotFindInAdditionalMetaData$str() {
        return cannotFindInAdditionalMetaData;
    }
    @Override
    public final void cannotObtainHost(final String host) {
        super.log.logf(FQCN, WARN, null, cannotObtainHost$str(), host);
    }
    private static final String cannotObtainHost = "JBWS022118: Cannot obtain host for vituralHost %s, use default host";
    protected String cannotObtainHost$str() {
        return cannotObtainHost;
    }
    @Override
    public final void cannotObtainPort(final String host) {
        super.log.logf(FQCN, WARN, null, cannotObtainPort$str(), host);
    }
    private static final String cannotObtainPort = "JBWS022119: Cannot obtain port for vituralHost %s, use default port";
    protected String cannotObtainPort$str() {
        return cannotObtainPort;
    }
}
