/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.wsf.framework.deployment;

//$Id: IdentityDeploymentAspect.java 7255 2008-05-30 18:17:18Z richard.opalka@jboss.com $
import org.jboss.wsf.spi.WSFRuntime;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspect;

/**
 * Identity deployment aspect that does nothing 
 *
 * @author richard.opalka@jboss.org
 * @since 30-May-2008
 */
public final class IdentityDeploymentAspect extends DeploymentAspect
{

   @Override
   public void create(Deployment dep, WSFRuntime runtime)
   {
      // does nothing
   }

   @Override
   public void destroy(Deployment dep, WSFRuntime runtime)
   {
      // does nothing
   }

   @Override
   public void start(Deployment dep, WSFRuntime runtime)
   {
      // does nothing
   }

   @Override
   public void stop(Deployment dep, WSFRuntime runtime)
   {
      // does nothing
   }

}
