/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.ws.jaxws.smoke.tools;

// $Id: ScriptTestCase.java 7288 2008-06-03 12:56:10Z heiko.braun@jboss.com $

import java.io.*;

import org.jboss.wsf.test.JBossWSTest;

/**
 * [JBWS-1793] Provide a test case for the tools scripts that reside under JBOSS_HOME/bin
 * 
 * http://jira.jboss.org/jira/browse/JBWS-1793
 * 
 * Test the wsprovide and wsconsume scripts that reside
 * under JBOSS_HOME/bin. This basically verifies all dependencies are
 * met to run the shell scripts.
 * 
 * @author Heiko.Braun@jboss.com
 */
public class ScriptTestCase extends JBossWSTest
{
   private String WSDL_LOCATION = "jaxws/smoke/tools/wsdl/TestServiceCatalog.wsdl";
   private String ENDPOINT_CLASS = "org.jboss.test.ws.jaxws.smoke.tools.CalculatorBean";

   private String JBOSS_HOME;
   private String JAVA_HOME;
   private String CLASSES_DIR;
   private String TEST_DIR;
   private String OS;

   private String origJavaHome;

   protected void setUp() throws Exception
   {
      super.setUp();

      JBOSS_HOME = System.getProperty("jboss.home");
      CLASSES_DIR = System.getProperty("test.classes.directory");
      TEST_DIR = createResourceFile("..").getAbsolutePath();
      origJavaHome = System.getProperty("java.home");
      OS = System.getProperty("os.name").toLowerCase();
      
	  
      // the script requires the system JAVA_HOME, which points to the JDK not the JRE            
	  if(origJavaHome.indexOf("/jre")!=-1)
      {
         String JDK_HOME = origJavaHome.substring(0, origJavaHome.indexOf("/jre"));
         System.setProperty("java.home", JDK_HOME);
         JAVA_HOME= JDK_HOME;
      }
   }


   protected void tearDown() throws Exception
   {
      // reset surefire's JAVA_HOME
      System.setProperty("java.home", origJavaHome);
   }

   public void testWSConsumeFromCommandLine() throws Exception
   {
      if (isWindowsOS())
      {
         fail("This test has not been verified on windows");
      }

      // use absolute path for the output to be re-usable
      String absWsdlLoc = getResourceFile(WSDL_LOCATION).getAbsolutePath();
      String absOutput = new File(TEST_DIR, "wsconsume/java").getAbsolutePath();

      String command = JBOSS_HOME + "/bin/wsconsume.sh -v -k -o " + absOutput + " " + absWsdlLoc;
      Process p = executeCommand(command);

      // check status code
      assertStatusCode(p, "wsconsume");

      File javaSource = new File(TEST_DIR, "wsconsume/java/org/openuri/_2004/_04/helloworld/EndpointInterface.java");

      assertTrue("Service endpoint interface not generated", javaSource.exists());
   }

   public void testWSProvideFromCommandLine() throws Exception
   {
      if (isWindowsOS())
      {
         fail("This test has not been verified on windows");
      }

      String absOutput = new File(TEST_DIR, "wsprovide/java/").getAbsolutePath();

      String command = JBOSS_HOME + "/bin/wsprovide.sh -k -w -o " + absOutput + " --classpath " + CLASSES_DIR + " " + ENDPOINT_CLASS;
      Process p = executeCommand(command);

      // check status code
      assertStatusCode(p, "wsprovide");

      File javaSource = new File(TEST_DIR, "wsprovide/java/org/jboss/test/ws/jaxws/smoke/tools/jaxws/AddResponse.java");

      assertTrue("Response wrapper not generated", javaSource.exists());
   }

   private Process executeCommand(String command) throws IOException
   {
      // be verbose      
      System.out.println("cmd: " + command);

      Process p = Runtime.getRuntime().exec(command, new String[] { "JBOSS_HOME=" + JBOSS_HOME, "JAVA_HOME=" + JAVA_HOME });
      return p;
   }

   private void assertStatusCode(Process p, String s) throws InterruptedException
   {
      // check status code
      int status = p.waitFor();
      dumpStream(p.getInputStream());
      dumpStream(p.getErrorStream());

      assertTrue(s + " did exit with status " + status, status == 0);
   }

   private void dumpStream(InputStream in)
   {
      try
      {
         BufferedInputStream bin = new BufferedInputStream (in);
         StringBuffer out = new StringBuffer();
         byte[] b = new byte[4096];
         for (int n; (n = bin.read(b)) != -1;)
         {
            out.append(new String(b, 0, n));
         }

         System.out.println(out.toString());
      }
      catch (IOException e)
      {
         throw new RuntimeException("", e);
      }
   }

   private boolean isWindowsOS()
   {
      return ((OS.indexOf("nt") > -1) || (OS.indexOf("windows") > -1));
   }
}
