/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework.deployment;

import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspect;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.management.ServerConfigFactory;

public class EndpointAddressDeploymentAspect
extends DeploymentAspect {
    public void start(Deployment dep) {
        String contextRoot = dep.getService().getContextRoot();
        if (contextRoot == null) {
            throw new IllegalStateException("Cannot obtain context root");
        }
        SPIProvider provider = SPIProviderResolver.getInstance().getProvider();
        ServerConfigFactory spi = (ServerConfigFactory)provider.getSPI(ServerConfigFactory.class);
        ServerConfig serverConfig = spi.getServerConfig();
        String host = serverConfig.getWebServiceHost();
        int port = serverConfig.getWebServicePort();
        String hostAndPort = host + (port > 0 ? ":" + port : "");
        for (Endpoint ep : dep.getService().getEndpoints()) {
            String urlPattern = ep.getURLPattern();
            if (urlPattern == null) {
                throw new IllegalStateException("Cannot obtain url pattern");
            }
            if (urlPattern.endsWith("/*")) {
                urlPattern = urlPattern.substring(0, urlPattern.length() - 2);
            }
            ep.setAddress("http://" + hostAndPort + contextRoot + urlPattern);
        }
    }
}

