/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.ws.jaxws.jbws2985;

import java.net.URL;

import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.AddressingFeature;

import junit.framework.Test;

import org.jboss.test.ws.jaxws.jbws2985.generated.AddNumbers;
import org.jboss.test.ws.jaxws.jbws2985.generated.AddNumbersException_Exception;
import org.jboss.test.ws.jaxws.jbws2985.generated.AddNumbersService;
import org.jboss.test.ws.jaxws.jbws2985.generated.TooBigNumbersException_Exception;
import org.jboss.wsf.test.JBossWSTest;
import org.jboss.wsf.test.JBossWSTestSetup;

/**
 * [JBWS-2985] Ensure proper addressing action header.
 * 
 * @author <a href="mailto:ropalka@redhat.com">Richard Opalka</a>
 */
public class JBWS2985TestCase extends JBossWSTest
{
   private static final WebServiceFeature[] enabledNotRequiredwsf = { new AddressingFeature(true, false) };
   private static final WebServiceFeature[] disabledNotRequiredwsf = { new AddressingFeature(false, false) };

   public static Test suite()
   {
      return new JBossWSTestSetup(JBWS2985TestCase.class, "jaxws-jbws2985.war");
   }

   AddNumbers portEnabled = null;
   AddNumbers portDisabled = null;

   public void setUp() throws Exception
   {
      URL wsdlURL = new URL("http://" + getServerHost() + ":8080/jaxws-jbws2985/AddNumbersService?wsdl");
      AddNumbersService service = new AddNumbersService(wsdlURL);
      portEnabled = (AddNumbers) service.getPort(AddNumbers.class, enabledNotRequiredwsf);
      portDisabled = (AddNumbers) service.getPort(AddNumbers.class, disabledNotRequiredwsf);
   }

   public void testNoActionOnInputOutput() throws Exception
   {
      int result = portEnabled.addNumbersNoAction(10, 10);
      if (result != 20)
      {
         throw new Exception("Expected result=20, got result=" + result);
      }
   }

   public void testEmptyActionOnInputOutput() throws Exception
   {
      int result = portEnabled.addNumbersEmptyAction(10, 10);
      if (result != 20)
      {
         throw new Exception("Expected result=20, got result=" + result);
      }
   }

   public void testExplicitInputOutputActions1() throws Exception
   {
      int result = portEnabled.addNumbers(10, 10);
      if (result != 20)
      {
         throw new Exception("Expected result=20, got result=" + result);
      }
   }

   public void testExplicitInputOutputActions2() throws Exception
   {
      int result = portEnabled.addNumbers2(10, 10);
      if (result != 20)
      {
         throw new Exception("Expected result=20, got result=" + result);
      }
   }

   public void testDefaultOutputActionExplicitInputAction() throws Exception
   {
      int result = portEnabled.addNumbers3(10, 10);
      if (result != 20)
      {
         throw new Exception("Expected result=20, got result=" + result);
      }
   }

   public void testSendingWrongSOAPActionHTTPHeaderValue() throws Exception
   {
      int result = portEnabled.addNumbers4(10, 10);
      if (result != 20)
      {
         throw new Exception("Expected result=20, got result=" + result);
      }
   }

   public void testOneFaultExplicitAction() throws Exception
   {
      try
      {
         portEnabled.addNumbersFault1(-10, 10);
         fail();
      }
      catch (AddNumbersException_Exception ex)
      {
         // expected
      }
   }

   public void testTwoFaultsExplicitAction1() throws Exception
   {
      try
      {
         portEnabled.addNumbersFault2(-10, 10);
         fail();
      }
      catch (AddNumbersException_Exception ex)
      {
         // expected
      }
   }

   public void testTwoFaultsExplicitAction2() throws Exception
   {
      try
      {
         portEnabled.addNumbersFault2(20, 10);
         fail();
      }
      catch (TooBigNumbersException_Exception ex)
      {
         // expected
      }
   }

   public void testTwoFaultsExplicitAddNumbersFault3() throws Exception
   {
      try
      {
         portEnabled.addNumbersFault3(-10, 10);
         fail();
      }
      catch (AddNumbersException_Exception ex)
      {
         // expected
      }
   }

   public void testTwoFaultsDefaultTooBigNumbersFault3() throws Exception
   {
      try
      {
         portEnabled.addNumbersFault3(20, 10);
         fail();
      }
      catch (TooBigNumbersException_Exception ex)
      {
         // expected
      }
   }

   public void testTwoFaultsExplicitAddNumbersFault4() throws Exception
   {
      try
      {
         portEnabled.addNumbersFault4(-10, 10);
         fail();
      }
      catch (AddNumbersException_Exception ex)
      {
         // expected
      }
   }

   public void testTwoFaultsDefaultTooBigNumbersFault4() throws Exception
   {
      try
      {
         portEnabled.addNumbersFault4(20, 10);
         fail();
      }
      catch (TooBigNumbersException_Exception ex)
      {
         // expected
      }
   }

   public void testTwoFaultsDefaultAddNumbersFault5() throws Exception
   {
      try
      {
         portEnabled.addNumbersFault5(-10, 10);
         fail();
      }
      catch (AddNumbersException_Exception ex)
      {
         // expected
      }
   }

   public void testTwoFaultsExplicitTooBigNumbersFault5() throws Exception
   {
      try
      {
         portEnabled.addNumbersFault5(20, 10);
         fail();
      }
      catch (TooBigNumbersException_Exception ex)
      {
         // expected
      }
   }

   public void testOnlyFaultActionsBothExplicit1() throws Exception
   {
      try
      {
         portEnabled.addNumbersFault6(-10, 10);
         fail();
      }
      catch (AddNumbersException_Exception ex)
      {
         // expected
      }
   }

   public void testOnlyFaultActionsBothExplicit2() throws Exception
   {
      try
      {
         portEnabled.addNumbersFault6(20, 10);
         fail();
      }
      catch (TooBigNumbersException_Exception ex)
      {
         // expected
      }
   }

   public void testOnlyFaultActionsFault7BothEmpty1() throws Exception
   {
      try
      {
         portEnabled.addNumbersFault7(-10, 10);
         fail();
      }
      catch (AddNumbersException_Exception ex)
      {
         // expected
      }
   }

   public void testOnlyFaultActionsFault7BothEmpty2() throws Exception
   {
      try
      {
         portEnabled.addNumbersFault7(20, 10);
         fail();
      }
      catch (TooBigNumbersException_Exception ex)
      {
         // expected
      }
   }
}
