/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.ws.jaxws.jbws3022.service;

import javax.xml.ws.handler.soap.SOAPMessageContext;

import org.jboss.test.ws.jaxws.common.Handler_Util;
import org.jboss.test.ws.jaxws.common.W3CAddressingConstants;
import org.jboss.test.ws.jaxws.jbws3022.common.AbstractSOAPHandler;
import org.jboss.test.ws.jaxws.jbws3022.common.TestConstants;

public final class ServerSOAPHandler extends AbstractSOAPHandler
{
   protected String whichHandler()
   {
      return "ServerSOAPHandler";
   }

   protected void checkInboundAction(final SOAPMessageContext context, final String oper, final String action)
   {
      if (Handler_Util.checkForMsg(context, "testAnonymousResponsesAssertion"))
      {
         assertAnonymousResponsesAddressingHeaders(context, action);
      }
      else if (Handler_Util.checkForMsg(context, "testNonAnonymousResponsesAssertion"))
      {
         assertNonAnonymousResponsesAddressingHeaders(context, action);
      }
   }

   private void assertAnonymousResponsesAddressingHeaders(final SOAPMessageContext messageCtx, final String action)
   {
      super.assertActionHeaderValue(TestConstants.TEST_ANONYMOUS_RESPONSES_ASSERTION_IN_ACTION, action);

      final String messageID = super.getHeaderValue(W3CAddressingConstants.WSA_MESSAGEID_QNAME, messageCtx);
      assert messageID != null;

      final String to = super.getHeaderValue(W3CAddressingConstants.WSA_TO_QNAME, messageCtx);
      assert to != null;

      super.assertAnonymousAddressURI(W3CAddressingConstants.WSA_REPLYTO_QNAME, messageCtx);
   }

   private void assertNonAnonymousResponsesAddressingHeaders(final SOAPMessageContext messageCtx, final String action)
   {
      super.assertActionHeaderValue(TestConstants.TEST_NONANONYMOUS_RESPONSES_ASSERTION_IN_ACTION, action);

      final String messageID = super.getHeaderValue(W3CAddressingConstants.WSA_MESSAGEID_QNAME, messageCtx);
      assert messageID != null;

      final String to = super.getHeaderValue(W3CAddressingConstants.WSA_TO_QNAME, messageCtx);
      assert to != null;

      super.assertNonAnonymousAddressURI(W3CAddressingConstants.WSA_REPLYTO_QNAME, messageCtx);
   }
}
