/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.ws.jaxws.common;

import javax.xml.soap.SOAPMessage;
import javax.xml.ws.LogicalMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.LogicalMessageContext;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import javax.xml.transform.Source;

import org.jboss.wsf.common.DOMUtils;

public final class Handler_Util
{

   public static boolean checkForMsg(MessageContext context, String whichMsg)
   {
      boolean foundIt = false;
      try
      {
         if (context instanceof LogicalMessageContext)
         {
            LogicalMessage lm = ((LogicalMessageContext) context).getMessage();
            if (lm != null)
            {
               Source source = lm.getPayload();
               if (source != null)
               {
                  String msg = JAXWS_Util.getDOMResultAsString(JAXWS_Util.getSourceAsDOMResult(source));

                  if (msg.indexOf(whichMsg) > -1)
                  {
                     foundIt = true;
                  }
               }
            }
         }
         else
         {
            SOAPMessage soapMsg = ((SOAPMessageContext) context).getMessage();

            String msg = DOMUtils.node2String(soapMsg.getSOAPPart());
            if (msg != null)
            {
               if (msg.indexOf(whichMsg) > -1)
               {
                  foundIt = true;
               }
            }
         }
      }
      catch (Exception e)
      {
         e.printStackTrace();
      }

      return foundIt;
   }

}
