/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.ws.jaxws.jbws2991.service;

import javax.xml.ws.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPException;

import org.jboss.test.ws.jaxws.common.ActionNotSupportedException;
import org.jboss.test.ws.jaxws.common.Handler_Util;
import org.jboss.test.ws.jaxws.common.WsaBaseSOAPHandler;
import org.jboss.test.ws.jaxws.jbws2991.common.TestConstants;

public class ServerSOAPHandler extends WsaBaseSOAPHandler
{
   String testName = null;

   protected void checkInboundAction(SOAPMessageContext context, String oper, String action)
   {
      if (Handler_Util.checkForMsg(context, "ClientEnabledNotREQServerEnabledNotREQ"))
      {
         verifyClientEnabledNotREQServerEnabledNotREQ(context, action);
      }
      else if (Handler_Util.checkForMsg(context, "ClientEnabledNotREQServerEnabledREQ"))
      {
         verifyClientEnabledNotREQServerEnabledREQ(context, action);
      }
      else if (Handler_Util.checkForMsg(context, "ClientEnabledNotREQServerUsingDefaults"))
      {
         verifyClientEnabledNotREQServerUsingDefaults(context, action);
      }
      else if (Handler_Util.checkForMsg(context, "ClientEnabledNotREQServerNotEnabled"))
      {
         verifyClientEnabledNotREQServerNotEnabled(context, action);
      }
      else if (Handler_Util.checkForMsg(context, "ClientNotEnabledServerEnabledNotREQ"))
      {
         verifyClientNotEnabledServerEnabledNotREQ(context, action);
      }
      else if (Handler_Util.checkForMsg(context, "ClientNotEnabledServerEnabledREQ"))
      {
         verifyClientNotEnabledServerEnabledREQ(context, action);
      }
      else if (Handler_Util.checkForMsg(context, "ClientEnabledREQServerNotEnabled"))
      {
         verifyClientEnabledREQServerNotEnabled(context, action);
      }
   }

   private void verifyClientEnabledNotREQServerEnabledNotREQ(SOAPMessageContext context, String action)
   {
      checkAddressingHeadersExist(context, action);
   }

   private void verifyClientEnabledNotREQServerUsingDefaults(SOAPMessageContext context, String action)
   {
      checkAddressingHeadersExist(context, action);
   }

   private void verifyClientNotEnabledServerEnabledNotREQ(SOAPMessageContext context, String action)
   {
      checkAddressingHeadersDoNotExist(context, action);
   }

   private void verifyClientEnabledNotREQServerEnabledREQ(SOAPMessageContext context, String action)
   {
      checkAddressingHeadersExist(context, action);
   }

   private void verifyClientNotEnabledServerEnabledREQ(SOAPMessageContext context, String action)
   {
      checkAddressingHeadersDoNotExist(context, action);
   }

   private void verifyClientEnabledNotREQServerNotEnabled(SOAPMessageContext context, String action)
   {
      checkAddressingHeadersExist(context, action);
   }

   private void verifyClientEnabledREQServerNotEnabled(SOAPMessageContext context, String action)
   {
      checkAddressingHeadersExist(context, action);
   }

   private void verifyAction(String action)
   {
      System.out.println("ServerSOAPHandler.verifyAction: [action=" + action + "]");
      if (testName.equals("ClientEnabledNotREQServerNotEnabled") || testName.equals("ClientEnabledREQServerNotEnabled"))
      {
         if (!action.equals(TestConstants.ADD_NUMBERS_IN_ACTION4))
         {
            throw new ActionNotSupportedException("Expected:" + TestConstants.ADD_NUMBERS_IN_ACTION4 + ", Actual:"
                  + action);
         }
      }
      else if (!action.equals(TestConstants.ADD_NUMBERS_IN_ACTION))
      {
         throw new ActionNotSupportedException("Expected:" + TestConstants.ADD_NUMBERS_IN_ACTION + ", Actual:" + action);
      }
   }

   private void checkAddressingHeadersExist(SOAPMessageContext context, String action)
   {
      System.out.println("ServerSOAPHandler.checkAddressingHeadersExist");
      verifyAction(action);
      checkInboundToExist(context);
      checkInboundMessageIdExist(context);
      checkInboundReplyToExist(context);
   }

   private void checkAddressingHeadersDoNotExist(SOAPMessageContext context, String action)
   {
      System.out.println("ServerSOAPHandler.checkAddressingHeadersDoNotExist");
      checkActionDoesNotExist(action);
      checkInboundToDoesNotExist(context);
      checkInboundMessageIdDoesNotExist(context);
      checkInboundReplyToDoesNotExist(context);
   }

   protected String getAction(SOAPMessageContext context) throws SOAPException
   {
      testName = (String) context.get("test.name");
      System.out.println("ServerSOAPHandler.getAction(): testName=" + testName);
      if (testName == null)
         return super.getAction(context);
      /* Headers MUST be present on SOAPRequest */
      else if (testName.equals("ClientEnabledNotREQServerEnabledNotREQ")
            || testName.equals("ClientEnabledNotREQServerEnabledREQ")
            || testName.equals("ClientEnabledNotREQServerUsingDefaults")
            || testName.equals("ClientEnabledREQServerNotEnabled"))
         return super.getAction(context);
      /* Headers MUST NOT be present on SOAPRequest */
      else if (testName.equals("ClientEnabledNotREQServerNotEnabled")
            || testName.equals("ClientNotEnabledServerEnabledREQ")
            || testName.equals("ClientNotEnabledServerEnabledNotREQ"))
         return super.getActionDoesNotExist(context);
      /* Fault case just return null */
      else
         return null;
   }

   protected String whichHandler()
   {
      return "ServerSOAPHandler";
   }
}
