/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.ws.jaxws.jbws3027.service;

import javax.xml.soap.SOAPException;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.soap.SOAPMessageContext;

import org.jboss.test.ws.jaxws.common.AddressingHeaderException;
import org.jboss.test.ws.jaxws.common.AddressingPropertyException;
import org.jboss.test.ws.jaxws.common.WsaBaseSOAPHandler;
import org.jboss.test.ws.jaxws.jbws3027.common.TestConstants;

public class ServerSOAPHandler extends WsaBaseSOAPHandler
{
   protected void checkInboundAction(SOAPMessageContext context, String oper, String action)
   {
      if (oper.equals("addNumbers2"))
      {
         if (action == null)
            return;
         if (action.equals("ActionNotSupported") || action.equals("ActionNotSupported2"))
            return;
         if (!action.equals(TestConstants.ADD_NUMBERS2_IN_ACTION))
         {
            throw new AddressingHeaderException("Expected:" + TestConstants.ADD_NUMBERS2_IN_ACTION + ", Actual:"
                  + action);
         }
      }
   }

   protected void checkInboundReplyTo(SOAPMessageContext context)
   {
      String replyTo = null;
      try
      {
         replyTo = getReplyTo(context);
      }
      catch (Exception e)
      {
         String testName = (String) context.get("test.name");
         if (testName.equals("missingReplyToHeader"))
            return;
         throw new WebServiceException(e);
      }
      if (replyTo == null)
      {
         throw new AddressingPropertyException("wsa:ReplyTo contains null");
      }
      if (replyTo.equals("invalid"))
      {
         throw new AddressingPropertyException("wsa:ReplyTo contains invalid value");
      }
      if (replyTo.equals(""))
      {
         throw new AddressingPropertyException("wsa:ReplyTo contains an empty value");
      }
   }

   protected String getAction(SOAPMessageContext context) throws SOAPException
   {
      String testName = (String) context.get("test.name");
      if (testName == null)
         return super.getAction(context);
      else if (!testName.equals("missingActionHeader"))
         return super.getAction(context);
      else
         return null;
   }

   protected String whichHandler()
   {
      return "ServerSOAPHandler";
   }
}
