/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2010, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.ws.jaxws.jbws3031;

import java.net.URL;

import junit.framework.Test;

import org.jboss.wsf.test.JBossWSTest;
import org.jboss.wsf.test.JBossWSTestSetup;

/**
 * [JBWS-3031] Use WSDL addressing metadata when addressing related annotations are not present on SEI.
 *
 * @author <a href="mailto:ropalka@redhat.com">Richard Opalka</a>
 */
public class JBWS3031TestCase extends JBossWSTest
{

   AddNumbersPortType port;

   public static Test suite()
   {
      return new JBossWSTestSetup(JBWS3031TestCase.class, "jaxws-jbws3031.war");
   }

   public void setUp() throws Exception
   {
      if (port == null)
      {
         URL wsdlURL = new URL("http://" + getServerHost() + ":8080/jaxws-jbws3031/Endpoint?wsdl");
         AddNumbersService service = new AddNumbersService(wsdlURL);
         port = (AddNumbersPortType) service.getPort(AddNumbersPortType.class);
      }
   }

   public void testAddNumbersDefaultAddNumbersFaultAction() throws Exception
   {
      try
      {
         port.addNumbers(-10, 10);
         fail("AddNumbersFault_Exception must be thrown");
      }
      catch (AddNumbersFault_Exception ex)
      {
         log.debug("WSA:Action headers are correct");
      }
   }

   public void testAddNumbersDefaultTooBigNumbersFaultAction() throws Exception
   {
      try
      {
         port.addNumbers(20, 20);
         fail("TooBigNumbersFault_Exception must be thrown");
      }
      catch (TooBigNumbersFault_Exception ex)
      {
         log.debug("WSA:Action headers are correct");
      }
   }

   public void testAddNumbers2ExplicitAddNumbers2FaultAction() throws Exception
   {
      try
      {
         port.addNumbers2(-10, 10);
         fail("AddNumbers2Fault must be thrown");
      }
      catch (AddNumbers2Fault ex)
      {
         log.debug("WSA:Action headers are correct");
      }
   }

   public void testAddNumbers2ExplicitTooBigNumbers2FaultAction() throws Exception
   {
      try
      {
         port.addNumbers2(20, 20);
         fail("TooBigNumbers2Fault must be thrown");
      }
      catch (TooBigNumbers2Fault ex)
      {
         log.debug("WSA:Action headers are correct");
      }
   }

   public void testAddNumbers3ExplicitAddNumbers3FaultAction() throws Exception
   {
      try
      {
         port.addNumbers3(-10, 10);
         fail("AddNumbers3Fault must be thrown");
      }
      catch (AddNumbers3Fault ex)
      {
         log.debug("WSA:Action headers are correct");
      }
   }

   public void testAddNumbers3DefaultTooBigNumbers3FaultAction() throws Exception
   {
      try
      {
         port.addNumbers3(20, 20);
         fail("TooBigNumbers3Fault must be thrown");
      }
      catch (TooBigNumbers3Fault ex)
      {
         log.debug("WSA:Action headers are correct");
      }
   }

   public void testAddNumbers4DefaultAddNumbers4FaultAction() throws Exception
   {
      try
      {
         port.addNumbers4(-10, 10);
         fail("AddNumbers4Fault must be thrown");
      }
      catch (AddNumbers4Fault ex)
      {
         log.debug("WSA:Action headers are correct");
      }
   }

   public void testAddNumbers4ExplicitTooBigNumbers4FaultAction() throws Exception
   {
      try
      {
         port.addNumbers4(20, 20);
         fail("TooBigNumbers4Fault must be thrown");
      }
      catch (TooBigNumbers4Fault ex)
      {
         log.debug("WSA:Action headers are correct");
      }
   }

   public void testAddNumbers5ExplicitAddNumbers5FaultAction() throws Exception
   {
      try
      {
         port.addNumbers5(-10, 20);
         fail("AddNumbers5Fault must be thrown");
      }
      catch (AddNumbers5Fault ex)
      {
         log.debug("WSA:Action headers are correct");
      }
   }

   public void testAddNumbers6EmptyAddNumbers6FaultAction() throws Exception
   {
      try
      {
         port.addNumbers6(-10, 20);
         fail("AddNumbers6Fault must be thrown");
      }
      catch (AddNumbers6Fault ex)
      {
         log.debug("WSA:Action headers are correct");
      }
   }

   public void testDefaultInputOutputActionExplicitMessageNames() throws Exception
   {
      port.addNumbers2(10, 10);
   }

   public void testDefaultInputOutputAction() throws Exception
   {
      port.addNumbers3(10, 10);
   }

   public void testEmptyInputOutputAction() throws Exception
   {
      port.addNumbers4(10, 10);
   }

   public void testExplicitInputOutputActions() throws Exception
   {
      port.addNumbers5(10, 10);
   }

   public void testExplicitInputDefaultOutputAction() throws Exception
   {
      port.addNumbers6(10, 10);
   }

}
