/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss42;

import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanProxy;
import org.jboss.mx.util.MBeanProxyCreationException;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.wsf.container.jboss42.DeployerHook;
import org.jboss.wsf.container.jboss42.DeployerInterceptorMBean;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.WSFRuntime;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentModelFactory;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.WSFDeploymentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDeployerHook
implements DeployerHook {
    protected final Logger log = Logger.getLogger(this.getClass());
    private WSFRuntime runtime;
    private DeploymentModelFactory deploymentModelFactory;
    private List<ObjectName> phaseOneInterceptors;
    private List<ObjectName> phaseTwoInterceptors;

    public void setRuntime(WSFRuntime runtime) {
        this.runtime = runtime;
    }

    public WSFRuntime getRuntime() {
        return this.runtime;
    }

    public DeploymentModelFactory getDeploymentModelFactory() {
        if (null == this.deploymentModelFactory) {
            SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
            this.deploymentModelFactory = (DeploymentModelFactory)spiProvider.getSPI(DeploymentModelFactory.class);
        }
        return this.deploymentModelFactory;
    }

    public ArchiveDeployment newDeployment(DeploymentInfo di) {
        try {
            DeploymentModelFactory factory = this.getDeploymentModelFactory();
            ArchiveDeployment dep = (ArchiveDeployment)factory.newDeployment(di.shortName, (ClassLoader)di.annotationsCl);
            if (di.parent != null) {
                DeploymentInfo parentInfo = di.parent;
                ArchiveDeployment parentDep = (ArchiveDeployment)factory.newDeployment(parentInfo.shortName, (ClassLoader)parentInfo.annotationsCl);
                dep.setParent(parentDep);
            }
            return dep;
        }
        catch (Exception ex) {
            throw new WSFDeploymentException("Cannot load spi.deployment.Deployment class", (Throwable)ex);
        }
    }

    public Endpoint newEndpoint(String targetBean) {
        try {
            return this.getDeploymentModelFactory().newEndpoint(targetBean);
        }
        catch (Exception ex) {
            throw new WSFDeploymentException("Cannot load spi.deployment.Endpoint class", (Throwable)ex);
        }
    }

    public void setPhaseOneInterceptors(List<ObjectName> phaseOneInterceptors) {
        this.phaseOneInterceptors = phaseOneInterceptors;
    }

    public void setPhaseTwoInterceptors(List<ObjectName> phaseTwoInterceptors) {
        this.phaseTwoInterceptors = phaseTwoInterceptors;
    }

    public boolean ignoreDeployment(DeploymentInfo unit) {
        return false;
    }

    public void start() {
        MBeanServer server = MBeanServerLocator.locateJBoss();
        try {
            DeployerInterceptorMBean interceptor;
            if (this.phaseOneInterceptors != null) {
                for (ObjectName oname : this.phaseOneInterceptors) {
                    interceptor = (DeployerInterceptorMBean)MBeanProxy.get(DeployerInterceptorMBean.class, (ObjectName)oname, (MBeanServer)server);
                    interceptor.addPhaseOneHook(this);
                }
            }
            if (this.phaseTwoInterceptors != null) {
                for (ObjectName oname : this.phaseTwoInterceptors) {
                    interceptor = (DeployerInterceptorMBean)MBeanProxy.get(DeployerInterceptorMBean.class, (ObjectName)oname, (MBeanServer)server);
                    interceptor.addPhaseTwoHook(this);
                }
            }
        }
        catch (MBeanProxyCreationException e) {
            throw new WSFDeploymentException((Throwable)e);
        }
    }

    public void stop() {
        MBeanServer server = MBeanServerLocator.locateJBoss();
        try {
            DeployerInterceptorMBean interceptor;
            if (this.phaseOneInterceptors != null) {
                for (ObjectName oname : this.phaseOneInterceptors) {
                    interceptor = (DeployerInterceptorMBean)MBeanProxy.get(DeployerInterceptorMBean.class, (ObjectName)oname, (MBeanServer)server);
                    interceptor.removePhaseOneHook(this);
                }
            }
            if (this.phaseTwoInterceptors != null) {
                for (ObjectName oname : this.phaseTwoInterceptors) {
                    interceptor = (DeployerInterceptorMBean)MBeanProxy.get(DeployerInterceptorMBean.class, (ObjectName)oname, (MBeanServer)server);
                    interceptor.removePhaseTwoHook(this);
                }
            }
        }
        catch (MBeanProxyCreationException e) {
            throw new WSFDeploymentException((Throwable)e);
        }
    }

    public abstract Deployment.DeploymentType getDeploymentType();
}

