/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss42;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jws.WebService;
import javax.xml.ws.WebServiceProvider;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.metadata.WebMetaData;
import org.jboss.wsf.common.URLLoaderAdapter;
import org.jboss.wsf.container.jboss42.AbstractDeployerHookJSE;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.Service;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXWSDeployerHookPreJSE
extends AbstractDeployerHookJSE {
    @Override
    public void undeploy(DeploymentInfo unit) {
    }

    @Override
    public Deployment.DeploymentType getDeploymentType() {
        return Deployment.DeploymentType.JAXWS_JSE;
    }

    @Override
    public Deployment createDeployment(DeploymentInfo di) {
        ArchiveDeployment dep = this.newDeployment(di);
        dep.setRootFile((UnifiedVirtualFile)new URLLoaderAdapter(di.localUrl));
        dep.setRuntimeClassLoader(null);
        dep.setType(this.getDeploymentType());
        Service service = dep.getService();
        WebMetaData webMetaData = (WebMetaData)di.metaData;
        if (webMetaData == null) {
            throw new IllegalStateException("Deployment unit does not contain web meta data");
        }
        dep.addAttachment(WebMetaData.class, (Object)webMetaData);
        List<AbstractDeployerHookJSE.Servlet> servlets = this.getRelevantServlets(webMetaData, di.annotationsCl);
        for (AbstractDeployerHookJSE.Servlet servlet : servlets) {
            String servletName = servlet.getServletName();
            String servletClass = servlet.getServletClass();
            Endpoint ep = this.newEndpoint(servletClass);
            ep.setShortName(servletName);
            service.addEndpoint(ep);
        }
        return dep;
    }

    @Override
    public boolean isWebServiceDeployment(DeploymentInfo unit) {
        if (!super.isWebServiceDeployment(unit)) {
            return false;
        }
        boolean isWebServiceDeployment = false;
        try {
            WebMetaData webMetaData = (WebMetaData)unit.metaData;
            List<AbstractDeployerHookJSE.Servlet> servlets = this.getRelevantServlets(webMetaData, unit.annotationsCl);
            isWebServiceDeployment = servlets.size() > 0;
        }
        catch (Exception ex) {
            this.log.error((Object)"Cannot process web deployment", (Throwable)ex);
        }
        return isWebServiceDeployment;
    }

    private List<AbstractDeployerHookJSE.Servlet> getRelevantServlets(WebMetaData webMetaData, ClassLoader loader) {
        ArrayList<AbstractDeployerHookJSE.Servlet> servlets = new ArrayList<AbstractDeployerHookJSE.Servlet>();
        for (Map.Entry entry : webMetaData.getServletClassMap().entrySet()) {
            String servletName = (String)entry.getKey();
            String servletClassName = (String)entry.getValue();
            if (servletClassName == null || servletClassName.length() == 0) continue;
            try {
                Class<?> servletClass = loader.loadClass(servletClassName.trim());
                boolean isWebService = servletClass.isAnnotationPresent(WebService.class);
                boolean isWebServiceProvider = servletClass.isAnnotationPresent(WebServiceProvider.class);
                if (!isWebService && !isWebServiceProvider) continue;
                servlets.add(new AbstractDeployerHookJSE.Servlet(servletName, servletClassName));
            }
            catch (ClassNotFoundException ex) {
                this.log.warn((Object)("Cannot load servlet class: " + servletClassName));
            }
        }
        return servlets;
    }
}

