/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss42;

import java.io.File;
import java.net.URL;
import javax.xml.ws.WebServiceException;
import org.jboss.wsf.container.jboss42.RewriteResults;
import org.jboss.wsf.container.jboss42.WebXMLRewriterImpl;
import org.jboss.wsf.spi.WSFRuntime;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspect;
import org.jboss.wsf.spi.deployment.Endpoint;

public class ModifyWebMetaDataDeploymentAspect
extends DeploymentAspect {
    private WebXMLRewriterImpl webXMLRewriter;

    public void setWebXMLRewriter(WebXMLRewriterImpl serviceEndpointPublisher) {
        this.webXMLRewriter = serviceEndpointPublisher;
    }

    public void create(Deployment dep, WSFRuntime rruntime) {
        RewriteResults results = this.webXMLRewriter.rewriteWebXml(dep);
        for (Endpoint ep : dep.getService().getEndpoints()) {
            if (ep.getTargetBeanName() != null) continue;
            String servletName = ep.getShortName();
            String beanClassName = results.sepTargetMap.get(servletName);
            if (beanClassName == null) {
                throw new IllegalStateException("Cannot obtain target bean for: " + servletName);
            }
            ep.setTargetBeanName(beanClassName);
        }
    }

    public void destroy(Deployment dep, WSFRuntime rruntime) {
        URL warURL = (URL)dep.getProperty("org.jboss.ws.webapp.url");
        File warFile = new File(warURL.getFile());
        if (!warFile.isDirectory()) {
            throw new WebServiceException("Expected a war directory: " + warURL);
        }
        File webXML = new File(warURL.getFile() + "/WEB-INF/web.xml");
        if (!webXML.isFile()) {
            throw new WebServiceException("Cannot find web.xml: " + webXML);
        }
        try {
            File orgWebXML = new File(webXML.getCanonicalPath() + ".org");
            webXML.delete();
            if (!orgWebXML.renameTo(webXML)) {
                throw new WebServiceException("Cannot rename web.xml: " + orgWebXML);
            }
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw new WebServiceException((Throwable)e);
        }
    }
}

