/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservices.integration.tomcat;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossServletsMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.AuthConstraintMetaData;
import org.jboss.metadata.web.spec.LoginConfigMetaData;
import org.jboss.metadata.web.spec.SecurityConstraintMetaData;
import org.jboss.metadata.web.spec.ServletMappingMetaData;
import org.jboss.metadata.web.spec.ServletMetaData;
import org.jboss.metadata.web.spec.TransportGuaranteeType;
import org.jboss.metadata.web.spec.UserDataConstraintMetaData;
import org.jboss.metadata.web.spec.WebResourceCollectionMetaData;
import org.jboss.metadata.web.spec.WebResourceCollectionsMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class WebMetaDataHelper {
    private static final String STAR_STRING = "*";
    private static final String GET_STRING = "GET";
    private static final String POST_STRING = "POST";
    private static List<String> getAndPostMethods;
    private static List<String> onlyPostMethod;
    private static List<String> allRoles;

    private WebMetaDataHelper() {
    }

    static List<String> getUrlPatterns(String urlPattern) {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(urlPattern);
        return linkedList;
    }

    static List<String> getHttpMethods(boolean secureWsdlAccess) {
        return secureWsdlAccess ? getAndPostMethods : onlyPostMethod;
    }

    static List<String> getAllRoles() {
        return allRoles;
    }

    static JBossServletsMetaData getServlets(JBossWebMetaData jbossWebMD) {
        JBossServletsMetaData servletsMD = jbossWebMD.getServlets();
        if (servletsMD == null) {
            servletsMD = new JBossServletsMetaData();
            jbossWebMD.setServlets(servletsMD);
        }
        return servletsMD;
    }

    static List<ServletMappingMetaData> getServletMappings(JBossWebMetaData jbossWebMD) {
        LinkedList servletMappingsMD = jbossWebMD.getServletMappings();
        if (servletMappingsMD == null) {
            servletMappingsMD = new LinkedList();
            jbossWebMD.setServletMappings(servletMappingsMD);
        }
        return servletMappingsMD;
    }

    static List<SecurityConstraintMetaData> getSecurityConstraints(JBossWebMetaData jbossWebMD) {
        LinkedList securityConstraintsMD = jbossWebMD.getSecurityContraints();
        if (securityConstraintsMD == null) {
            securityConstraintsMD = new LinkedList();
            jbossWebMD.setSecurityContraints(securityConstraintsMD);
        }
        return securityConstraintsMD;
    }

    static LoginConfigMetaData getLoginConfig(JBossWebMetaData jbossWebMD) {
        LoginConfigMetaData loginConfigMD = jbossWebMD.getLoginConfig();
        if (loginConfigMD == null) {
            loginConfigMD = new LoginConfigMetaData();
            jbossWebMD.setLoginConfig(loginConfigMD);
        }
        return loginConfigMD;
    }

    static List<ParamValueMetaData> getContextParams(JBossWebMetaData jbossWebMD) {
        LinkedList contextParamsMD = jbossWebMD.getContextParams();
        if (contextParamsMD == null) {
            contextParamsMD = new LinkedList();
            jbossWebMD.setContextParams(contextParamsMD);
        }
        return contextParamsMD;
    }

    static WebResourceCollectionsMetaData getWebResourceCollections(SecurityConstraintMetaData securityConstraintMD) {
        WebResourceCollectionsMetaData webResourceCollectionsMD = securityConstraintMD.getResourceCollections();
        if (webResourceCollectionsMD == null) {
            webResourceCollectionsMD = new WebResourceCollectionsMetaData();
            securityConstraintMD.setResourceCollections(webResourceCollectionsMD);
        }
        return webResourceCollectionsMD;
    }

    static List<ParamValueMetaData> getServletInitParams(ServletMetaData servletMD) {
        LinkedList initParamsMD = servletMD.getInitParam();
        if (initParamsMD == null) {
            initParamsMD = new LinkedList();
            servletMD.setInitParam(initParamsMD);
        }
        return initParamsMD;
    }

    static SecurityConstraintMetaData newSecurityConstraint(List<SecurityConstraintMetaData> securityConstraintsMD) {
        SecurityConstraintMetaData securityConstraintMD = new SecurityConstraintMetaData();
        securityConstraintsMD.add(securityConstraintMD);
        return securityConstraintMD;
    }

    static WebResourceCollectionMetaData newWebResourceCollection(String servletName, String urlPattern, boolean securedWsdl, WebResourceCollectionsMetaData webResourceCollectionsMD) {
        WebResourceCollectionMetaData webResourceCollectionMD = new WebResourceCollectionMetaData();
        webResourceCollectionMD.setWebResourceName(servletName);
        webResourceCollectionMD.setUrlPatterns(WebMetaDataHelper.getUrlPatterns(urlPattern));
        webResourceCollectionMD.setHttpMethods(WebMetaDataHelper.getHttpMethods(securedWsdl));
        webResourceCollectionsMD.add((Object)webResourceCollectionMD);
        return webResourceCollectionMD;
    }

    static JBossServletMetaData newServlet(String servletName, String servletClass, JBossServletsMetaData servletsMD) {
        JBossServletMetaData servletMD = new JBossServletMetaData();
        servletMD.setServletName(servletName);
        servletMD.setServletClass(servletClass);
        servletsMD.add((MappableMetaData)servletMD);
        return servletMD;
    }

    static ServletMappingMetaData newServletMapping(String servletName, List<String> urlPatterns, List<ServletMappingMetaData> servletMappingsMD) {
        ServletMappingMetaData servletMappingMD = new ServletMappingMetaData();
        servletMappingMD.setServletName(servletName);
        servletMappingMD.setUrlPatterns(urlPatterns);
        servletMappingsMD.add(servletMappingMD);
        return servletMappingMD;
    }

    static AuthConstraintMetaData newAuthConstraint(List<String> roleNames, SecurityConstraintMetaData securityConstraintMD) {
        AuthConstraintMetaData authConstraintMD = new AuthConstraintMetaData();
        authConstraintMD.setRoleNames(roleNames);
        securityConstraintMD.setAuthConstraint(authConstraintMD);
        return authConstraintMD;
    }

    static UserDataConstraintMetaData newUserDataConstraint(String transportGuarantee, SecurityConstraintMetaData securityConstraintMD) {
        UserDataConstraintMetaData userDataConstraintMD = new UserDataConstraintMetaData();
        TransportGuaranteeType transportGuaranteeValue = TransportGuaranteeType.valueOf((String)transportGuarantee);
        userDataConstraintMD.setTransportGuarantee(transportGuaranteeValue);
        securityConstraintMD.setUserDataConstraint(userDataConstraintMD);
        return userDataConstraintMD;
    }

    static ParamValueMetaData newParamValue(String key, String value, List<ParamValueMetaData> paramsMD) {
        ParamValueMetaData paramValueMD = WebMetaDataHelper.newParamValue(key, value);
        paramsMD.add(paramValueMD);
        return paramValueMD;
    }

    private static ParamValueMetaData newParamValue(String key, String value) {
        ParamValueMetaData paramMD = new ParamValueMetaData();
        paramMD.setParamName(key);
        paramMD.setParamValue(value);
        return paramMD;
    }

    static {
        LinkedList<String> getAndPostList = new LinkedList<String>();
        getAndPostList.add(GET_STRING);
        getAndPostList.add(POST_STRING);
        getAndPostMethods = Collections.unmodifiableList(getAndPostList);
        LinkedList<String> onlyPostList = new LinkedList<String>();
        onlyPostList.add(POST_STRING);
        onlyPostMethod = Collections.unmodifiableList(onlyPostList);
        LinkedList<String> roleNamesList = new LinkedList<String>();
        roleNamesList.add(STAR_STRING);
        allRoles = Collections.unmodifiableList(roleNamesList);
    }
}

