/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss50.invocation;

import java.lang.reflect.Method;
import javax.ejb.EJBContext;
import javax.management.ObjectName;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.ws.WebServiceException;
import org.jboss.aop.Advisor;
import org.jboss.aop.Dispatcher;
import org.jboss.aop.MethodInfo;
import org.jboss.ejb3.BeanContext;
import org.jboss.ejb3.BeanContextLifecycleCallback;
import org.jboss.ejb3.EJBContainerInvocation;
import org.jboss.ejb3.stateless.StatelessBeanContext;
import org.jboss.ejb3.stateless.StatelessContainer;
import org.jboss.injection.lang.reflect.BeanProperty;
import org.jboss.wsf.common.ObjectNameFactory;
import org.jboss.wsf.container.jboss50.invocation.AbstractInvocationHandler;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.invocation.ExtensibleWebServiceContext;
import org.jboss.wsf.spi.invocation.Invocation;
import org.jboss.wsf.spi.invocation.InvocationType;
import org.jboss.wsf.spi.invocation.WebServiceContextFactory;

public class InvocationHandlerEJB3
extends AbstractInvocationHandler {
    private ObjectName objectName;

    InvocationHandlerEJB3() {
    }

    public Invocation createInvocation() {
        return new Invocation();
    }

    public void init(Endpoint ep) {
        String ejbName = ep.getShortName();
        ArchiveDeployment dep = (ArchiveDeployment)ep.getService().getDeployment();
        String nameStr = "jboss.j2ee:name=" + ejbName + ",service=EJB3,jar=" + dep.getSimpleName();
        if (dep.getParent() != null) {
            nameStr = nameStr + ",ear=" + dep.getParent().getSimpleName();
        }
        this.objectName = ObjectNameFactory.create((String)nameStr.toString());
        Dispatcher dispatcher = Dispatcher.singleton;
        if (dispatcher.getRegistered((Object)this.objectName.getCanonicalName()) == null) {
            throw new WebServiceException("Cannot find service endpoint target: " + this.objectName);
        }
    }

    public void invoke(Endpoint ep, Invocation wsInv) throws Exception {
        try {
            Dispatcher dispatcher = Dispatcher.singleton;
            StatelessContainer container = (StatelessContainer)dispatcher.getRegistered((Object)this.objectName.getCanonicalName());
            Class beanClass = container.getBeanClass();
            Method method = this.getImplMethod(beanClass, wsInv.getJavaMethod());
            Object[] args = wsInv.getArgs();
            MethodInfo info = container.getMethodInfo(method);
            EJBContainerInvocation jbInv = new EJBContainerInvocation(info);
            jbInv.setAdvisor((Advisor)container);
            jbInv.setArguments(args);
            jbInv.setContextCallback((BeanContextLifecycleCallback)new CallbackImpl(wsInv));
            Object retObj = jbInv.invokeNext();
            wsInv.setReturnValue(retObj);
        }
        catch (Throwable th) {
            this.handleInvocationException(th);
        }
    }

    static class CallbackImpl
    implements BeanContextLifecycleCallback {
        private javax.xml.ws.handler.MessageContext jaxwsMessageContext;
        private MessageContext jaxrpcMessageContext;

        public CallbackImpl(Invocation epInv) {
            this.jaxrpcMessageContext = (MessageContext)epInv.getInvocationContext().getAttachment(MessageContext.class);
            this.jaxwsMessageContext = (javax.xml.ws.handler.MessageContext)epInv.getInvocationContext().getAttachment(javax.xml.ws.handler.MessageContext.class);
        }

        public void attached(BeanContext beanCtx) {
            StatelessBeanContext sbc = (StatelessBeanContext)beanCtx;
            sbc.setMessageContextJAXRPC(this.jaxrpcMessageContext);
            BeanProperty beanProp = sbc.getWebServiceContextProperty();
            if (beanProp != null) {
                EJBContext ejbCtx = beanCtx.getEJBContext();
                SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
                ExtensibleWebServiceContext wsContext = ((WebServiceContextFactory)spiProvider.getSPI(WebServiceContextFactory.class)).newWebServiceContext(InvocationType.JAXWS_EJB3, this.jaxwsMessageContext);
                wsContext.addAttachment(EJBContext.class, (Object)ejbCtx);
                beanProp.set(beanCtx.getInstance(), (Object)wsContext);
            }
        }

        public void released(BeanContext beanCtx) {
            StatelessBeanContext sbc = (StatelessBeanContext)beanCtx;
            sbc.setMessageContextJAXRPC(null);
            BeanProperty beanProp = sbc.getWebServiceContextProperty();
            if (beanProp != null) {
                beanProp.set(beanCtx.getInstance(), null);
            }
        }
    }
}

