/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservices.integration.invocation;

import java.lang.reflect.Method;
import javax.xml.ws.WebServiceException;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.webservices.integration.invocation.AbstractInvocationHandler;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.invocation.Invocation;
import org.jboss.wsf.spi.invocation.integration.InvocationContextCallback;
import org.jboss.wsf.spi.invocation.integration.ServiceEndpointContainer;
import org.jboss.wsf.spi.util.KernelLocator;

final class InvocationHandlerEJB3
extends AbstractInvocationHandler {
    private final KernelController controller = KernelLocator.getKernel().getController();
    private String containerName;
    private ServiceEndpointContainer serviceEndpointContainer;

    InvocationHandlerEJB3() {
    }

    public void init(Endpoint endpoint) {
        this.containerName = (String)endpoint.getProperty("org.jboss.wsf.spi.invocation.ContainerName");
        if (this.containerName == null) {
            throw new IllegalArgumentException("Container name cannot be null");
        }
    }

    private synchronized ServiceEndpointContainer getEjb3Container() {
        boolean ejb3ContainerNotInitialized;
        boolean bl = ejb3ContainerNotInitialized = this.serviceEndpointContainer == null;
        if (ejb3ContainerNotInitialized) {
            ControllerContext context = this.controller.getInstalledContext((Object)this.containerName);
            if (context == null) {
                throw new WebServiceException("Cannot find service endpoint target: " + this.containerName);
            }
            this.serviceEndpointContainer = (ServiceEndpointContainer)context.getTarget();
        }
        return this.serviceEndpointContainer;
    }

    public void invoke(Endpoint endpoint, Invocation wsInvocation) throws Exception {
        try {
            ServiceEndpointContainer ejbContainer = this.getEjb3Container();
            EJB3InvocationContextCallback invocationCallback = new EJB3InvocationContextCallback(wsInvocation);
            Class implClass = ejbContainer.getServiceImplementationClass();
            Method seiMethod = wsInvocation.getJavaMethod();
            Method implMethod = this.getImplMethod(implClass, seiMethod);
            Object[] args = wsInvocation.getArgs();
            Object retObj = ejbContainer.invokeEndpoint(implMethod, args, (InvocationContextCallback)invocationCallback);
            wsInvocation.setReturnValue(retObj);
        }
        catch (Throwable t) {
            this.log.error((Object)("Method invocation failed with exception: " + t.getMessage()), t);
            this.handleInvocationException(t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EJB3InvocationContextCallback
    implements InvocationContextCallback {
        private Invocation wsInvocation;

        public EJB3InvocationContextCallback(Invocation wsInvocation) {
            this.wsInvocation = wsInvocation;
        }

        public <T> T get(Class<T> attachmentType) {
            return (T)this.wsInvocation.getInvocationContext().getAttachment(attachmentType);
        }
    }
}

