/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.webservices.integration.tomcat;

import org.jboss.ws.common.integration.WSHelper;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.ws.common.integration.AbstractDeploymentAspect;

/**
 * A deployment aspect that generates web app meta data for EJB endpoints.
 *
 * @author <a href="mailto:ropalka@redhat.com">Richard Opalka</a>
 * @author <a href="mailto:tdiesler@redhat.com">Thomas Diesler</a>
 */
public final class WebMetaDataCreatingDeploymentAspect extends AbstractDeploymentAspect
{
   /** Web meta data creator. */
   private WebMetaDataCreator webMetaDataCreator = new WebMetaDataCreator();

   /**
    * Constructor.
    */
   public WebMetaDataCreatingDeploymentAspect()
   {
      super();
   }

   /**
    * Creates web meta data for EJB deployments.
    *
    * @param dep webservice deployment
    */
   @Override
   public void start(final Deployment dep)
   {
      final boolean isEjbDeployment = WSHelper.isEjbDeployment(dep);

      if (isEjbDeployment)
      {
         this.log.debug("Creating web meta data for EJB webservice deployment: " + dep.getSimpleName());
         this.webMetaDataCreator.create(dep);
      }
   }
}
