/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservices.integration.util;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.jws.WebService;
import javax.servlet.Servlet;
import javax.xml.ws.WebServiceProvider;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.metadata.common.jboss.WebserviceDescriptionMetaData;
import org.jboss.metadata.common.jboss.WebserviceDescriptionsMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.ServletMetaData;
import org.jboss.webservices.integration.WebServiceDeclaration;
import org.jboss.webservices.integration.WebServiceDeployment;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.metadata.webservices.WebservicesMetaData;

public final class ASHelper {
    private static final ResourceBundle bundle = BundleUtils.getBundle(ASHelper.class);
    public static final String CONTAINER_NAME = "org.jboss.wsf.spi.invocation.ContainerName";
    private static final Logger LOGGER = Logger.getLogger(ASHelper.class);

    private ASHelper() {
    }

    public static boolean isWebServiceDeployment(DeploymentUnit unit) {
        return ASHelper.getOptionalAttachment(unit, Deployment.class) != null;
    }

    public static boolean isJaxrpcEjbDeployment(DeploymentUnit unit) {
        boolean hasWebservicesMD = ASHelper.hasAttachment(unit, WebservicesMetaData.class);
        boolean hasJBossMD = unit.getAllMetaData(JBossMetaData.class).size() > 0;
        return hasWebservicesMD && hasJBossMD;
    }

    public static boolean isJaxrpcJseDeployment(DeploymentUnit unit) {
        boolean hasWebservicesMD = ASHelper.hasAttachment(unit, WebservicesMetaData.class);
        boolean hasJBossWebMD = ASHelper.hasAttachment(unit, JBossWebMetaData.class);
        if (hasWebservicesMD && hasJBossWebMD) {
            return ASHelper.getJaxrpcServlets(unit).size() > 0;
        }
        return false;
    }

    public static boolean isJaxwsEjbDeployment(DeploymentUnit unit) {
        boolean hasWSDeployment = ASHelper.hasAttachment(unit, WebServiceDeployment.class);
        if (hasWSDeployment) {
            return ASHelper.getJaxwsEjbs(unit).size() > 0;
        }
        return false;
    }

    public static boolean isJaxwsJseDeployment(DeploymentUnit unit) {
        boolean hasJBossWebMD = ASHelper.hasAttachment(unit, JBossWebMetaData.class);
        if (hasJBossWebMD) {
            return ASHelper.getJaxwsServlets(unit).size() > 0;
        }
        return false;
    }

    public static List<ServletMetaData> getJaxwsServlets(DeploymentUnit unit) {
        return ASHelper.getWebServiceServlets(unit, true);
    }

    public static List<ServletMetaData> getJaxrpcServlets(DeploymentUnit unit) {
        return ASHelper.getWebServiceServlets(unit, false);
    }

    public static List<WebServiceDeclaration> getJaxwsEjbs(DeploymentUnit unit) {
        WebServiceDeployment wsDeployment = ASHelper.getRequiredAttachment(unit, WebServiceDeployment.class);
        ArrayList<WebServiceDeclaration> endpoints = new ArrayList<WebServiceDeclaration>();
        for (WebServiceDeclaration ejbContainer : wsDeployment.getServiceEndpoints()) {
            if (!ASHelper.isWebServiceBean(ejbContainer)) continue;
            endpoints.add(ejbContainer);
        }
        return endpoints;
    }

    public static boolean isWebServiceBean(WebServiceDeclaration ejbContainerAdapter) {
        boolean isWebService = ejbContainerAdapter.getAnnotation(WebService.class) != null;
        boolean isWebServiceProvider = ejbContainerAdapter.getAnnotation(WebServiceProvider.class) != null;
        return isWebService || isWebServiceProvider;
    }

    public static String getEndpointName(ServletMetaData servletMD) {
        String endpointClass = servletMD.getServletClass();
        return endpointClass != null ? endpointClass.trim() : null;
    }

    public static ServletMetaData getServletForName(JBossWebMetaData jbossWebMD, String servletName) {
        for (JBossServletMetaData servlet : jbossWebMD.getServlets()) {
            if (!servlet.getName().equals(servletName)) continue;
            return servlet;
        }
        throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_FIND_SERVLET_FOR_LINK", (Object[])new Object[]{servletName}));
    }

    public static Class<?> getEndpointClass(ServletMetaData servletMD, ClassLoader loader) {
        boolean notJSP;
        String endpointClassName = ASHelper.getEndpointName(servletMD);
        boolean bl = notJSP = endpointClassName != null && endpointClassName.length() > 0;
        if (notJSP) {
            try {
                boolean notServlet;
                Class<?> endpointClass = loader.loadClass(endpointClassName);
                boolean bl2 = notServlet = !Servlet.class.isAssignableFrom(endpointClass);
                if (notServlet) {
                    return endpointClass;
                }
            }
            catch (ClassNotFoundException cnfe) {
                LOGGER.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_LOAD_SERVLET_CLASS", (Object[])new Object[]{endpointClassName}), (Throwable)cnfe);
            }
        }
        return null;
    }

    public static <A> A getRequiredAttachment(DeploymentUnit unit, Class<A> key) {
        Object value = unit.getAttachment(key);
        if (value == null) {
            LOGGER.error((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_FIND_ATTACHMENT_IN_DEPLOYMENT_UNIT", (Object[])new Object[]{key}));
            throw new IllegalStateException();
        }
        return (A)value;
    }

    public static <A> A getOptionalAttachment(DeploymentUnit unit, Class<A> key) {
        return (A)unit.getAttachment(key);
    }

    public static boolean hasAttachment(DeploymentUnit unit, Class<?> key) {
        return ASHelper.getOptionalAttachment(unit, key) != null;
    }

    public static WebserviceDescriptionMetaData getWebserviceDescriptionMetaData(WebserviceDescriptionsMetaData wsDescriptionsMD) {
        if (wsDescriptionsMD != null) {
            if (wsDescriptionsMD.size() > 1) {
                LOGGER.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"MULTIPLE_WS_DESP_ELEMENTS_NOT_SUPPORTED", (Object[])new Object[0]));
            }
            if (wsDescriptionsMD.size() > 0) {
                return (WebserviceDescriptionMetaData)wsDescriptionsMD.iterator().next();
            }
        }
        return null;
    }

    private static List<ServletMetaData> getWebServiceServlets(DeploymentUnit unit, boolean jaxws) {
        JBossWebMetaData jbossWebMD = ASHelper.getRequiredAttachment(unit, JBossWebMetaData.class);
        ClassLoader loader = unit.getClassLoader();
        ArrayList<ServletMetaData> endpoints = new ArrayList<ServletMetaData>();
        for (JBossServletMetaData servletMD : jbossWebMD.getServlets()) {
            boolean isJaxrpcEndpoint;
            Class<?> endpointClass = ASHelper.getEndpointClass((ServletMetaData)servletMD, loader);
            if (endpointClass == null) continue;
            boolean isWebService = endpointClass.isAnnotationPresent(WebService.class);
            boolean isWebServiceProvider = endpointClass.isAnnotationPresent(WebServiceProvider.class);
            boolean isJaxwsEndpoint = jaxws && (isWebService || isWebServiceProvider);
            boolean bl = isJaxrpcEndpoint = !jaxws && !isWebService && !isWebServiceProvider;
            if (!isJaxwsEndpoint && !isJaxrpcEndpoint) continue;
            endpoints.add((ServletMetaData)servletMD);
        }
        return endpoints;
    }
}

