/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservices.integration.config;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ResourceBundle;
import javax.management.JMException;
import javax.management.ObjectName;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.management.AbstractServerConfig;
import org.jboss.ws.common.management.AbstractServerConfigMBean;

public final class ServerConfigImpl
extends AbstractServerConfig
implements AbstractServerConfigMBean {
    private static final ResourceBundle bundle = BundleUtils.getBundle(ServerConfigImpl.class);

    public File getServerTempDir() {
        return this.getDirFromServerConfig("ServerTempLocation");
    }

    public File getHomeDir() {
        return this.getDirFromServerConfig("JBossHome");
    }

    public File getServerDataDir() {
        return this.getDirFromServerConfig("ServerDataLocation");
    }

    private File getDirFromServerConfig(String attributeName) {
        ObjectName on = OBJECT_NAME_SERVER_CONFIG;
        URL location = null;
        try {
            location = (URL)this.getMbeanServer().getAttribute(on, attributeName);
        }
        catch (JMException e) {
            throw new RuntimeException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"COULD_NOT_OBTAIN_ATTRIBUTE_FROM", (Object[])new Object[]{attributeName, on}), e);
        }
        File dir = null;
        try {
            dir = new File(location.toURI());
        }
        catch (URISyntaxException urise) {
            throw new RuntimeException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"COULD_NOT_DESIRED_DIRECTORY_FROM_URL", (Object[])new Object[]{location}), urise);
        }
        return dir;
    }
}

