/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservices.integration.deployers.deployment;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.jboss.webservices.integration.deployers.deployment.DeploymentModelBuilder;
import org.jboss.webservices.integration.deployers.deployment.WSVirtualFileFilter;
import org.jboss.webservices.integration.injection.VirtualFileAdaptor;
import org.jboss.webservices.integration.util.ASHelper;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.ResourceLoaderAdapter;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentModelFactory;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;

abstract class AbstractDeploymentModelBuilder
implements DeploymentModelBuilder {
    private static final ResourceBundle bundle = BundleUtils.getBundle(AbstractDeploymentModelBuilder.class);
    private static final WSVirtualFileFilter WS_FILE_FILTER = new WSVirtualFileFilter();
    protected final Logger log = Logger.getLogger(this.getClass());
    private final DeploymentModelFactory deploymentModelFactory;

    protected AbstractDeploymentModelBuilder() {
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        this.deploymentModelFactory = (DeploymentModelFactory)spiProvider.getSPI(DeploymentModelFactory.class);
    }

    @Override
    public final void newDeploymentModel(DeploymentUnit unit) {
        ArchiveDeployment dep = this.newDeployment(unit);
        this.build((Deployment)dep, unit);
        dep.addAttachment(DeploymentUnit.class, (Object)unit);
        unit.addAttachment(Deployment.class, (Object)dep);
    }

    protected abstract void build(Deployment var1, DeploymentUnit var2);

    protected final Endpoint newHttpEndpoint(String endpointClass, String endpointName, Deployment dep) {
        if (endpointName == null) {
            throw new NullPointerException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"NULL_ENDPOINT_NAME", (Object[])new Object[0]));
        }
        if (endpointClass == null) {
            throw new NullPointerException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"NULL_ENDPOINT_CLASS", (Object[])new Object[0]));
        }
        Endpoint endpoint = this.deploymentModelFactory.newHttpEndpoint(endpointClass);
        endpoint.setShortName(endpointName);
        dep.getService().addEndpoint(endpoint);
        return endpoint;
    }

    protected final Endpoint newJMSEndpoint(String endpointClass, String endpointName, Deployment dep) {
        if (endpointName == null) {
            throw new NullPointerException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"NULL_ENDPOINT_NAME", (Object[])new Object[0]));
        }
        if (endpointClass == null) {
            throw new NullPointerException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"NULL_ENDPOINT_CLASS", (Object[])new Object[0]));
        }
        Endpoint endpoint = this.deploymentModelFactory.newJMSEndpoint(endpointClass);
        endpoint.setShortName(endpointName);
        dep.getService().addEndpoint(endpoint);
        return endpoint;
    }

    private ArchiveDeployment newDeployment(DeploymentUnit unit) {
        this.log.debug((Object)("Creating new WS deployment model for: " + unit));
        ArchiveDeployment dep = this.newDeployment(unit.getSimpleName(), unit.getClassLoader());
        if (unit instanceof VFSDeploymentUnit) {
            VFSDeploymentUnit vfsUnit = (VFSDeploymentUnit)unit;
            List virtualFiles = vfsUnit.getMetaDataFiles((VirtualFileFilter)WS_FILE_FILTER);
            HashSet<VirtualFileAdaptor> uVirtualFiles = new HashSet<VirtualFileAdaptor>();
            for (VirtualFile vf : virtualFiles) {
                uVirtualFiles.add(new VirtualFileAdaptor(vf));
            }
            dep.setMetadataFiles(new LinkedList(uVirtualFiles));
        }
        if (unit.getParent() != null) {
            String parentDeploymentName = unit.getParent().getSimpleName();
            ClassLoader parentClassLoader = unit.getParent().getClassLoader();
            this.log.debug((Object)("Creating new WS deployment model for parent: " + unit.getParent()));
            ArchiveDeployment parentDep = this.newDeployment(parentDeploymentName, parentClassLoader);
            dep.setParent(parentDep);
        }
        if (unit instanceof VFSDeploymentUnit) {
            dep.setRootFile((UnifiedVirtualFile)new VirtualFileAdaptor(((VFSDeploymentUnit)unit).getRoot()));
        } else {
            dep.setRootFile((UnifiedVirtualFile)new ResourceLoaderAdapter(unit.getClassLoader()));
        }
        dep.setRuntimeClassLoader(unit.getClassLoader());
        Deployment.DeploymentType deploymentType = ASHelper.getRequiredAttachment(unit, Deployment.DeploymentType.class);
        dep.setType(deploymentType);
        return dep;
    }

    private ArchiveDeployment newDeployment(String name, ClassLoader loader) {
        return (ArchiveDeployment)this.deploymentModelFactory.newDeployment(name, loader);
    }

    protected final <A> A getAndPropagateAttachment(Class<A> attachment, DeploymentUnit unit, Deployment dep) {
        A attachmentValue = ASHelper.getOptionalAttachment(unit, attachment);
        if (attachmentValue != null) {
            dep.addAttachment(attachment, attachmentValue);
            return attachmentValue;
        }
        throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"DEPLOYMENT_UNIT_DOES_NOT_CONTAIN", (Object[])new Object[]{attachment}));
    }
}

