/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservices.integration.invocation;

import java.lang.reflect.Method;
import java.util.ResourceBundle;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceException;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.injection.ThreadLocalAwareWebServiceContext;
import org.jboss.ws.common.invocation.AbstractInvocationHandler;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.invocation.Invocation;
import org.jboss.wsf.spi.invocation.InvocationContext;
import org.jboss.wsf.spi.invocation.integration.InvocationContextCallback;
import org.jboss.wsf.spi.invocation.integration.ServiceEndpointContainer;
import org.jboss.wsf.spi.ioc.IoCContainerProxy;
import org.jboss.wsf.spi.ioc.IoCContainerProxyFactory;

final class InvocationHandlerEJB3
extends AbstractInvocationHandler {
    private static final ResourceBundle bundle = BundleUtils.getBundle(InvocationHandlerEJB3.class);
    private static final String EJB3_JNDI_PREFIX = "java:env/";
    private final IoCContainerProxy iocContainer;
    private String containerName;
    private ServiceEndpointContainer serviceEndpointContainer;

    InvocationHandlerEJB3() {
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        IoCContainerProxyFactory iocContainerFactory = (IoCContainerProxyFactory)spiProvider.getSPI(IoCContainerProxyFactory.class);
        this.iocContainer = iocContainerFactory.getContainer();
    }

    public void init(Endpoint endpoint) {
        this.containerName = (String)endpoint.getProperty("org.jboss.wsf.spi.invocation.ContainerName");
        if (this.containerName == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CONTAINER_NAME_CANNOT_BE_NULL", (Object[])new Object[0]));
        }
    }

    private synchronized ServiceEndpointContainer getEjb3Container() {
        boolean ejb3ContainerNotInitialized;
        boolean bl = ejb3ContainerNotInitialized = this.serviceEndpointContainer == null;
        if (ejb3ContainerNotInitialized) {
            this.serviceEndpointContainer = (ServiceEndpointContainer)this.iocContainer.getBean(this.containerName, ServiceEndpointContainer.class);
            if (this.serviceEndpointContainer == null) {
                throw new WebServiceException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_FIND_SERVICE_ENDPOINT_TARGET", (Object[])new Object[]{this.containerName}));
            }
        }
        return this.serviceEndpointContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Endpoint endpoint, Invocation wsInvocation) throws Exception {
        try {
            this.onBeforeInvocation(wsInvocation);
            ServiceEndpointContainer ejbContainer = this.getEjb3Container();
            EJB3InvocationContextCallback invocationCallback = new EJB3InvocationContextCallback(wsInvocation);
            Class implClass = ejbContainer.getServiceImplementationClass();
            Method seiMethod = wsInvocation.getJavaMethod();
            Method implMethod = this.getImplMethod(implClass, seiMethod);
            Object[] args = wsInvocation.getArgs();
            Object retObj = ejbContainer.invokeEndpoint(implMethod, args, (InvocationContextCallback)invocationCallback);
            wsInvocation.setReturnValue(retObj);
        }
        catch (Throwable t) {
            this.log.error((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"METHOD_INVOCATION_FAILED", (Object[])new Object[]{t.getMessage()}), t);
            this.handleInvocationException(t);
        }
        finally {
            this.onAfterInvocation(wsInvocation);
        }
    }

    public Context getJNDIContext(Endpoint ep) throws NamingException {
        EJBContainer ejb3Container = (EJBContainer)this.getEjb3Container();
        return (Context)ejb3Container.getEnc().lookup(EJB3_JNDI_PREFIX);
    }

    public void onBeforeInvocation(Invocation invocation) {
        WebServiceContext wsContext = this.getWebServiceContext(invocation);
        ThreadLocalAwareWebServiceContext.getInstance().setMessageContext(wsContext);
    }

    public void onAfterInvocation(Invocation invocation) {
        ThreadLocalAwareWebServiceContext.getInstance().setMessageContext(null);
    }

    private WebServiceContext getWebServiceContext(Invocation invocation) {
        InvocationContext invocationContext = invocation.getInvocationContext();
        return (WebServiceContext)invocationContext.getAttachment(WebServiceContext.class);
    }

    private static final class EJB3InvocationContextCallback
    implements InvocationContextCallback {
        private Invocation wsInvocation;

        public EJB3InvocationContextCallback(Invocation wsInvocation) {
            this.wsInvocation = wsInvocation;
        }

        public <T> T get(Class<T> attachmentType) {
            return (T)this.wsInvocation.getInvocationContext().getAttachment(attachmentType);
        }
    }
}

