/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservices.integration.deployers;

import java.net.URL;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import org.jboss.deployers.vfs.plugins.classloader.UrlIntegrationDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.util.StringPropertyReplacer;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.wsf.spi.management.ServerConfig;

public abstract class JAXRPCIntegrationClassPathDeployer<T>
extends UrlIntegrationDeployer<T> {
    private static final ResourceBundle bundle = BundleUtils.getBundle(JAXRPCIntegrationClassPathDeployer.class);
    private Set<String> libs;
    private boolean integrationLibsFound = false;
    private ServerConfig wsServerConfig;
    private boolean stackRequiresIntegration;

    public JAXRPCIntegrationClassPathDeployer(Class<T> input) {
        super(input);
    }

    protected abstract boolean isClassPathChangeRequired(VFSDeploymentUnit var1);

    protected boolean isIntegrationDeployment(VFSDeploymentUnit unit) {
        return this.stackRequiresIntegration && this.integrationLibsFound && this.isClassPathChangeRequired(unit);
    }

    public void start() {
    }

    protected Set<URL> getJBossWSIntegrationUrls() {
        HashSet<URL> result = new HashSet<URL>();
        try {
            for (String file : this.libs) {
                String url = this.getServerHome() + file;
                VirtualFile integrationLib = VFS.getChild((URL)new URL(url = StringPropertyReplacer.replaceProperties((String)url)));
                if (integrationLib != null && integrationLib.exists()) {
                    this.integrationLibsFound = true;
                    result.add(integrationLib.toURL());
                    continue;
                }
                this.log.debug((Object)("Could not find JAX-RPC integration lib: " + url));
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNEXPECTED_ERROR", (Object[])new Object[]{e}));
        }
        return result;
    }

    protected String getServerHome() {
        return "${jboss.server.home.url}";
    }

    public Set<String> getLibs() {
        return this.libs;
    }

    public void setLibs(Set<String> libs) {
        this.libs = libs;
        this.setIntegrationURLs(this.getJBossWSIntegrationUrls());
    }

    public ServerConfig getWsServerConfig() {
        return this.wsServerConfig;
    }

    public void setWsServerConfig(ServerConfig wsServerConfig) {
        this.wsServerConfig = wsServerConfig;
        this.stackRequiresIntegration = !wsServerConfig.getImplementationTitle().toLowerCase().contains("native");
    }
}

