/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservices.integration.injection;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ResourceBundle;
import javax.ejb.EJB;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.ejbref.resolver.spi.EjbReference;
import org.jboss.ejb3.ejbref.resolver.spi.EjbReferenceResolver;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.injection.resolvers.AbstractReferenceResolver;

final class EJBBeanReferenceResolver
extends AbstractReferenceResolver<EJB> {
    private static final ResourceBundle bundle = BundleUtils.getBundle(EJBBeanReferenceResolver.class);
    private final DeploymentUnit unit;
    private final EjbReferenceResolver delegate;

    EJBBeanReferenceResolver(DeploymentUnit unit, EjbReferenceResolver delegate) {
        super(EJB.class);
        if (unit == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"DEPLOYMENT_UNIT_CANNOT_BE_NULL", (Object[])new Object[0]));
        }
        if (delegate == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"EJB_REFERENCE_RESOLVER_CANNOT_BE_NULL", (Object[])new Object[0]));
        }
        this.unit = unit;
        this.delegate = delegate;
    }

    protected String resolveField(Field field) {
        EJB ejbAnnotation = field.getAnnotation(EJB.class);
        Class<?> type = field.getType();
        EjbReference reference = this.getEjbReference(ejbAnnotation, type);
        return this.delegate.resolveEjb(this.unit, reference);
    }

    protected String resolveMethod(Method method) {
        EJB ejbAnnotation = method.getAnnotation(EJB.class);
        Class<?> type = method.getParameterTypes()[0];
        EjbReference reference = this.getEjbReference(ejbAnnotation, type);
        return this.delegate.resolveEjb(this.unit, reference);
    }

    private EjbReference getEjbReference(EJB ejbAnnotation, Class<?> type) {
        String beanInterface = ejbAnnotation.beanInterface().getName();
        if (Object.class.getName().equals(beanInterface)) {
            beanInterface = type.getName();
        }
        return new EjbReference(ejbAnnotation.beanName(), beanInterface, ejbAnnotation.mappedName());
    }
}

