/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservices.integration.injection;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.jws.HandlerChain;
import javax.naming.Referenceable;
import javax.xml.namespace.QName;
import javax.xml.ws.RespectBinding;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceRef;
import javax.xml.ws.WebServiceRefs;
import javax.xml.ws.soap.Addressing;
import javax.xml.ws.soap.MTOM;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.switchboard.javaee.environment.Handler;
import org.jboss.switchboard.javaee.environment.InjectionTarget;
import org.jboss.switchboard.javaee.environment.PortComponent;
import org.jboss.switchboard.javaee.environment.ServiceRefType;
import org.jboss.switchboard.javaee.jboss.environment.JBossPortComponent;
import org.jboss.switchboard.javaee.jboss.environment.JBossServiceRefType;
import org.jboss.switchboard.mc.spi.MCBasedResourceProvider;
import org.jboss.switchboard.spi.Resource;
import org.jboss.webservices.integration.injection.VirtualFileAdaptor;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedCallPropertyMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainsMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedInitParamMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedPortComponentRefMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedStubPropertyMetaData;
import org.jboss.wsf.spi.serviceref.ServiceRefHandler;
import org.jboss.wsf.spi.serviceref.ServiceRefHandlerFactory;

public final class ServiceRefResourceProvider
implements MCBasedResourceProvider<ServiceRefType> {
    private static final ResourceBundle bundle = BundleUtils.getBundle(ServiceRefResourceProvider.class);
    private static final Logger log = Logger.getLogger(ServiceRefResourceProvider.class);
    private final ServiceRefHandler delegate;

    public ServiceRefResourceProvider() {
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        this.delegate = ((ServiceRefHandlerFactory)spiProvider.getSPI(ServiceRefHandlerFactory.class)).getServiceRefHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource provide(DeploymentUnit deploymentUnit, ServiceRefType serviceRefSBMD) {
        ClassLoader newLoader = deploymentUnit.getClassLoader();
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(newLoader);
            UnifiedVirtualFile vfsRoot = this.getUnifiedVirtualFile(deploymentUnit);
            UnifiedServiceRefMetaData serviceRefUMDM = this.getUnifiedServiceRefMetaData(vfsRoot, serviceRefSBMD, newLoader);
            Referenceable jndiReferenceable = this.delegate.createReferenceable(serviceRefUMDM);
            ServiceRefResource serviceRefResource = new ServiceRefResource(jndiReferenceable);
            return serviceRefResource;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    public Class<ServiceRefType> getEnvironmentEntryType() {
        return ServiceRefType.class;
    }

    private UnifiedVirtualFile getUnifiedVirtualFile(DeploymentUnit deploymentUnit) {
        DeploymentUnit tempDeploymentUnit = deploymentUnit;
        while (tempDeploymentUnit.isComponent()) {
            tempDeploymentUnit = tempDeploymentUnit.getParent();
        }
        if (tempDeploymentUnit instanceof VFSDeploymentUnit) {
            VFSDeploymentUnit vdu = (VFSDeploymentUnit)tempDeploymentUnit;
            return new VirtualFileAdaptor(vdu.getRoot());
        }
        throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CAN_ONLY_HANDLE_REAL_VFS_DEPLOYMENTS", (Object[])new Object[]{tempDeploymentUnit}));
    }

    private UnifiedServiceRefMetaData getUnifiedServiceRefMetaData(UnifiedVirtualFile vfsRoot, ServiceRefType serviceRefSBMD, ClassLoader loader) {
        List handlerChainsSBMD;
        Collection handlersSBMD;
        Collection portComponentsSBMD;
        UnifiedServiceRefMetaData serviceRefUMDM = new UnifiedServiceRefMetaData(vfsRoot);
        serviceRefUMDM.setServiceRefName(serviceRefSBMD.getName());
        serviceRefUMDM.setServiceRefType(serviceRefSBMD.getType());
        serviceRefUMDM.setServiceInterface(serviceRefSBMD.getServiceInterface());
        serviceRefUMDM.setWsdlFile(serviceRefSBMD.getWsdlFile());
        serviceRefUMDM.setMappingFile(serviceRefSBMD.getMappingFile());
        serviceRefUMDM.setServiceQName(serviceRefSBMD.getQName());
        serviceRefUMDM.setHandlerChain(serviceRefSBMD.getHandlerChain());
        serviceRefUMDM.setAddressingAnnotationSpecified(serviceRefSBMD.isAddressingFeatureEnabled());
        serviceRefUMDM.setAddressingEnabled(serviceRefSBMD.isAddressingEnabled());
        serviceRefUMDM.setAddressingRequired(serviceRefSBMD.isAddressingRequired());
        serviceRefUMDM.setAddressingResponses(serviceRefSBMD.getAddressingResponses());
        serviceRefUMDM.setMtomAnnotationSpecified(serviceRefSBMD.isMtomFeatureEnabled());
        serviceRefUMDM.setMtomEnabled(serviceRefSBMD.isMtomEnabled());
        serviceRefUMDM.setMtomThreshold(serviceRefSBMD.getMtomThreshold());
        serviceRefUMDM.setRespectBindingAnnotationSpecified(serviceRefSBMD.isRespectBindingFeatureEnabled());
        serviceRefUMDM.setRespectBindingEnabled(serviceRefSBMD.isRespectBindingEnabled());
        if (serviceRefSBMD.getInjectionTargets() != null && serviceRefSBMD.getInjectionTargets().size() > 0) {
            if (serviceRefSBMD.getInjectionTargets().size() > 1) {
                // empty if block
            }
            InjectionTarget injectionTarget = (InjectionTarget)serviceRefSBMD.getInjectionTargets().iterator().next();
            AccessibleObject anAlement = this.findInjectionTarget(loader, injectionTarget);
            this.processAnnotatedElement(anAlement, serviceRefUMDM);
        }
        if ((portComponentsSBMD = serviceRefSBMD.getPortComponents()) != null) {
            for (PortComponent portComponentSBMD : portComponentsSBMD) {
                UnifiedPortComponentRefMetaData portComponentUMDM = this.getUnifiedPortComponentRefMetaData(serviceRefUMDM, portComponentSBMD);
                if (portComponentUMDM.getServiceEndpointInterface() != null || portComponentUMDM.getPortQName() != null) {
                    serviceRefUMDM.addPortComponentRef(portComponentUMDM);
                    continue;
                }
                log.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"IGNORING_PORT_REF", (Object[])new Object[]{portComponentUMDM}));
            }
        }
        if ((handlersSBMD = serviceRefSBMD.getHandlers()) != null) {
            for (Handler handlerSBMD : handlersSBMD) {
                UnifiedHandlerMetaData handlerUMDM = this.getUnifiedHandlerMetaData(handlerSBMD);
                serviceRefUMDM.addHandler(handlerUMDM);
            }
        }
        if ((handlerChainsSBMD = serviceRefSBMD.getHandlerChains()) != null) {
            UnifiedHandlerChainsMetaData handlerChainsUMDM = this.getUnifiedHandlerChainsMetaData(handlerChainsSBMD);
            serviceRefUMDM.setHandlerChains(handlerChainsUMDM);
        }
        if (serviceRefSBMD instanceof JBossServiceRefType) {
            this.processUnifiedJBossServiceRefMetaData(serviceRefUMDM, serviceRefSBMD);
        }
        this.processType(serviceRefUMDM);
        return serviceRefUMDM;
    }

    private void processUnifiedJBossServiceRefMetaData(UnifiedServiceRefMetaData serviceRefUMDM, ServiceRefType serviceRefSBMD) {
        JBossServiceRefType jbossServiceRefSBMD = (JBossServiceRefType)serviceRefSBMD;
        serviceRefUMDM.setServiceImplClass(jbossServiceRefSBMD.getServiceClass());
        serviceRefUMDM.setConfigName(jbossServiceRefSBMD.getConfigName());
        serviceRefUMDM.setConfigFile(jbossServiceRefSBMD.getConfigFile());
        serviceRefUMDM.setWsdlOverride(jbossServiceRefSBMD.getWsdlOverride());
        serviceRefUMDM.setHandlerChain(jbossServiceRefSBMD.getHandlerChain());
    }

    private UnifiedHandlerChainsMetaData getUnifiedHandlerChainsMetaData(List<org.jboss.switchboard.javaee.environment.HandlerChain> handlerChainsSBMD) {
        UnifiedHandlerChainsMetaData handlerChainsUMDM = new UnifiedHandlerChainsMetaData();
        for (org.jboss.switchboard.javaee.environment.HandlerChain handlerChainSBMD : handlerChainsSBMD) {
            UnifiedHandlerChainMetaData handlerChainUMDM = new UnifiedHandlerChainMetaData();
            handlerChainUMDM.setServiceNamePattern(handlerChainSBMD.getServiceNamePattern());
            handlerChainUMDM.setPortNamePattern(handlerChainSBMD.getPortNamePattern());
            handlerChainUMDM.setProtocolBindings(handlerChainSBMD.getProtocolBindings());
            List handlersSBMD = handlerChainSBMD.getHandlers();
            for (Handler handlerSBMD : handlersSBMD) {
                UnifiedHandlerMetaData handlerUMDM = this.getUnifiedHandlerMetaData(handlerSBMD);
                handlerChainUMDM.addHandler(handlerUMDM);
            }
            handlerChainsUMDM.addHandlerChain(handlerChainUMDM);
        }
        return handlerChainsUMDM;
    }

    private UnifiedHandlerMetaData getUnifiedHandlerMetaData(Handler handlerSBMD) {
        Collection handlerPortNamesSBMD;
        Collection handlerSoapRolesSBMD;
        Collection handlerSoapHeadersSBDM;
        UnifiedHandlerMetaData handlerUMDM = new UnifiedHandlerMetaData();
        handlerUMDM.setHandlerName(handlerSBMD.getHandlerName());
        handlerUMDM.setHandlerClass(handlerSBMD.getHandlerClass());
        Map handlerInitParamsSBMD = handlerSBMD.getInitParams();
        if (handlerInitParamsSBMD != null) {
            for (String initParamName : handlerInitParamsSBMD.keySet()) {
                UnifiedInitParamMetaData handlerInitParamUMDM = new UnifiedInitParamMetaData();
                handlerInitParamUMDM.setParamName(initParamName);
                handlerInitParamUMDM.setParamValue((String)handlerInitParamsSBMD.get(initParamName));
                handlerUMDM.addInitParam(handlerInitParamUMDM);
            }
        }
        if ((handlerSoapHeadersSBDM = handlerSBMD.getSoapHeaders()) != null) {
            for (QName soapHeader : handlerSoapHeadersSBDM) {
                handlerUMDM.addSoapHeader(soapHeader);
            }
        }
        if ((handlerSoapRolesSBMD = handlerSBMD.getSoapRoles()) != null) {
            for (String soapRole : handlerSoapRolesSBMD) {
                handlerUMDM.addSoapRole(soapRole);
            }
        }
        if ((handlerPortNamesSBMD = handlerSBMD.getPortNames()) != null) {
            for (String portName : handlerPortNamesSBMD) {
                handlerUMDM.addPortName(portName);
            }
        }
        return handlerUMDM;
    }

    private UnifiedPortComponentRefMetaData getUnifiedPortComponentRefMetaData(UnifiedServiceRefMetaData serviceRefUMDM, PortComponent portComponentSBMD) {
        UnifiedPortComponentRefMetaData portComponentUMDM = new UnifiedPortComponentRefMetaData(serviceRefUMDM);
        portComponentUMDM.setServiceEndpointInterface(portComponentSBMD.getEndpointInterface());
        portComponentUMDM.setMtomEnabled(portComponentSBMD.isMtomEnabled());
        portComponentUMDM.setMtomThreshold(portComponentSBMD.getMtomThreshold().intValue());
        org.jboss.switchboard.javaee.environment.Addressing addressingSBMD = portComponentSBMD.getAddressing();
        if (addressingSBMD != null) {
            portComponentUMDM.setAddressingAnnotationSpecified(true);
            portComponentUMDM.setAddressingEnabled(addressingSBMD.isEnabled());
            portComponentUMDM.setAddressingRequired(addressingSBMD.isRequired());
            portComponentUMDM.setAddressingResponses(addressingSBMD.getResponses());
        }
        if (portComponentSBMD.isRespectBindingEnabled()) {
            portComponentUMDM.setRespectBindingAnnotationSpecified(true);
            portComponentUMDM.setRespectBindingEnabled(true);
        }
        portComponentUMDM.setPortComponentLink(portComponentSBMD.getLink());
        if (portComponentSBMD instanceof JBossPortComponent) {
            this.processUnifiedJBossPortComponentRefMetaData(portComponentUMDM, portComponentSBMD);
        }
        return portComponentUMDM;
    }

    private void processUnifiedJBossPortComponentRefMetaData(UnifiedPortComponentRefMetaData portComponentUMDM, PortComponent portComponentSBMD) {
        Map callPropertiesSBMD;
        JBossPortComponent jbossPortComponentSBMD = (JBossPortComponent)portComponentSBMD;
        portComponentUMDM.setPortQName(jbossPortComponentSBMD.getPortQName());
        portComponentUMDM.setConfigName(jbossPortComponentSBMD.getConfigName());
        portComponentUMDM.setConfigFile(jbossPortComponentSBMD.getConfigFile());
        Map stubPropertiesSBMD = jbossPortComponentSBMD.getStubProperties();
        if (stubPropertiesSBMD != null) {
            for (String propertyName : stubPropertiesSBMD.keySet()) {
                UnifiedStubPropertyMetaData stubPropertyUMDM = new UnifiedStubPropertyMetaData();
                stubPropertyUMDM.setPropName(propertyName);
                stubPropertyUMDM.setPropValue((String)stubPropertiesSBMD.get(propertyName));
                portComponentUMDM.addStubProperty(stubPropertyUMDM);
            }
        }
        if ((callPropertiesSBMD = jbossPortComponentSBMD.getCallProperties()) != null) {
            for (String propertyName : callPropertiesSBMD.keySet()) {
                UnifiedCallPropertyMetaData callPropertyUMDM = new UnifiedCallPropertyMetaData();
                callPropertyUMDM.setPropName(propertyName);
                callPropertyUMDM.setPropValue((String)callPropertiesSBMD.get(propertyName));
                portComponentUMDM.addCallProperty(callPropertyUMDM);
            }
        }
    }

    private void processAnnotatedElement(AnnotatedElement anElement, UnifiedServiceRefMetaData serviceRefUMDM) {
        this.processAddressingAnnotation(anElement, serviceRefUMDM);
        this.processMTOMAnnotation(anElement, serviceRefUMDM);
        this.processRespectBindingAnnotation(anElement, serviceRefUMDM);
        this.processHandlerChainAnnotation(anElement, serviceRefUMDM);
        this.processServiceRefType(anElement, serviceRefUMDM);
    }

    private void processType(UnifiedServiceRefMetaData serviceRefUMDM) {
        boolean isJAXRPC = serviceRefUMDM.getMappingFile() != null || "javax.xml.rpc.Service".equals(serviceRefUMDM.getServiceInterface());
        serviceRefUMDM.setType(isJAXRPC ? ServiceRefHandler.Type.JAXRPC : ServiceRefHandler.Type.JAXWS);
    }

    private void processAddressingAnnotation(AnnotatedElement anElement, UnifiedServiceRefMetaData serviceRefUMDM) {
        Addressing addressingAnnotation = this.getAnnotation(anElement, Addressing.class);
        if (addressingAnnotation != null) {
            serviceRefUMDM.setAddressingAnnotationSpecified(true);
            serviceRefUMDM.setAddressingEnabled(addressingAnnotation.enabled());
            serviceRefUMDM.setAddressingRequired(addressingAnnotation.required());
            serviceRefUMDM.setAddressingResponses(addressingAnnotation.responses().toString());
        }
    }

    private void processMTOMAnnotation(AnnotatedElement anElement, UnifiedServiceRefMetaData serviceRefUMDM) {
        MTOM mtomAnnotation = this.getAnnotation(anElement, MTOM.class);
        if (mtomAnnotation != null) {
            serviceRefUMDM.setMtomAnnotationSpecified(true);
            serviceRefUMDM.setMtomEnabled(mtomAnnotation.enabled());
            serviceRefUMDM.setMtomThreshold(mtomAnnotation.threshold());
        }
    }

    private void processRespectBindingAnnotation(AnnotatedElement anElement, UnifiedServiceRefMetaData serviceRefUMDM) {
        RespectBinding respectBindingAnnotation = this.getAnnotation(anElement, RespectBinding.class);
        if (respectBindingAnnotation != null) {
            serviceRefUMDM.setRespectBindingAnnotationSpecified(true);
            serviceRefUMDM.setRespectBindingEnabled(respectBindingAnnotation.enabled());
        }
    }

    private void processServiceRefType(AnnotatedElement anElement, UnifiedServiceRefMetaData serviceRefUMDM) {
        if (anElement instanceof Field) {
            Class<?> targetClass = ((Field)anElement).getType();
            serviceRefUMDM.setServiceRefType(targetClass.getName());
            if (Service.class.isAssignableFrom(targetClass)) {
                serviceRefUMDM.setServiceInterface(targetClass.getName());
            }
        } else if (anElement instanceof Method) {
            Class<?> targetClass = ((Method)anElement).getParameterTypes()[0];
            serviceRefUMDM.setServiceRefType(targetClass.getName());
            if (Service.class.isAssignableFrom(targetClass)) {
                serviceRefUMDM.setServiceInterface(targetClass.getName());
            }
        } else {
            WebServiceRef serviceRefAnnotation = this.getWebServiceRefAnnotation(anElement, serviceRefUMDM);
            Class targetClass = null;
            if (serviceRefAnnotation != null && serviceRefAnnotation.type() != Object.class) {
                targetClass = serviceRefAnnotation.type();
                serviceRefUMDM.setServiceRefType(targetClass.getName());
                if (Service.class.isAssignableFrom(targetClass)) {
                    serviceRefUMDM.setServiceInterface(targetClass.getName());
                }
            }
        }
    }

    private void processHandlerChainAnnotation(AnnotatedElement anElement, UnifiedServiceRefMetaData serviceRefUMDM) {
        HandlerChain handlerChainAnnotation = this.getAnnotation(anElement, HandlerChain.class);
        if (handlerChainAnnotation != null) {
            String handlerChain = null;
            if (handlerChainAnnotation.file().length() > 0) {
                handlerChain = handlerChainAnnotation.file();
            }
            if (handlerChain != null) {
                try {
                    new URL(handlerChain);
                }
                catch (MalformedURLException ignored) {
                    Class<?> declaringClass = this.getDeclaringClass(anElement);
                    handlerChain = declaringClass.getPackage().getName().replace('.', '/') + "/" + handlerChain;
                }
                serviceRefUMDM.setHandlerChain(handlerChain);
            }
        }
    }

    private Class<?> getDeclaringClass(AnnotatedElement annotatedElement) {
        Class declaringClass = null;
        if (annotatedElement instanceof Field) {
            declaringClass = ((Field)annotatedElement).getDeclaringClass();
        } else if (annotatedElement instanceof Method) {
            declaringClass = ((Method)annotatedElement).getDeclaringClass();
        } else if (annotatedElement instanceof Class) {
            declaringClass = (Class)annotatedElement;
        }
        return declaringClass;
    }

    private <T extends Annotation> T getAnnotation(AnnotatedElement anElement, Class<T> annotationClass) {
        return anElement != null ? (T)anElement.getAnnotation(annotationClass) : null;
    }

    private WebServiceRef getWebServiceRefAnnotation(AnnotatedElement anElement, UnifiedServiceRefMetaData serviceRefUMDM) {
        WebServiceRef webServiceRefAnnotation = this.getAnnotation(anElement, WebServiceRef.class);
        WebServiceRefs webServiceRefsAnnotation = this.getAnnotation(anElement, WebServiceRefs.class);
        if (webServiceRefAnnotation == null && webServiceRefsAnnotation == null) {
            return null;
        }
        ArrayList<WebServiceRef> wsrefList = new ArrayList<WebServiceRef>();
        if (webServiceRefAnnotation != null) {
            wsrefList.add(webServiceRefAnnotation);
        }
        if (webServiceRefsAnnotation != null) {
            for (WebServiceRef webServiceRefAnn : webServiceRefsAnnotation.value()) {
                wsrefList.add(webServiceRefAnn);
            }
        }
        WebServiceRef returnValue = null;
        if (wsrefList.size() == 1) {
            returnValue = (WebServiceRef)wsrefList.get(0);
        } else {
            for (WebServiceRef webServiceRefAnn : wsrefList) {
                if (!serviceRefUMDM.getServiceRefName().endsWith(webServiceRefAnn.name())) continue;
                returnValue = webServiceRefAnn;
                break;
            }
        }
        return returnValue;
    }

    private AccessibleObject findInjectionTarget(ClassLoader loader, InjectionTarget target) {
        Class<?> clazz = null;
        try {
            clazz = loader.loadClass(target.getTargetClass());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"INJECTION_TARGET_CLASS_NOT_FOUND", (Object[])new Object[]{target.getTargetClass()}));
        }
        for (Field field : clazz.getDeclaredFields()) {
            if (!target.getTargetName().equals(field.getName())) continue;
            return field;
        }
        String targetName = this.getMethodName(target);
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.getName().equals(targetName)) continue;
            return method;
        }
        throw new RuntimeException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"INJECTION_TARGET_NOT_FOUND", (Object[])new Object[]{target.getTargetClass() + "." + target.getTargetName()}));
    }

    private String getMethodName(InjectionTarget target) {
        if (target.getTargetName() == null) {
            return null;
        }
        if (target.getTargetName().startsWith("set")) {
            return target.getTargetName();
        }
        return "set" + target.getTargetName().substring(0, 1).toUpperCase() + target.getTargetName().substring(1);
    }

    private static final class ServiceRefResource
    implements Resource {
        private final Referenceable target;

        private ServiceRefResource(Referenceable target) {
            this.target = target;
        }

        public Object getDependency() {
            return null;
        }

        public Object getTarget() {
            return this.target;
        }

        public Collection<?> getInvocationDependencies() {
            return null;
        }
    }
}

