/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservices.integration.metadata;

import org.jboss.logging.Logger;
import org.jboss.webservices.integration.metadata.PublishLocationAdapterImpl;
import org.jboss.ws.common.integration.WSHelper;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.metadata.j2ee.EJBArchiveMetaData;
import org.jboss.wsf.spi.metadata.j2ee.PublishLocationAdapter;
import org.jboss.wsf.spi.metadata.webservices.JBossPortComponentMetaData;
import org.jboss.wsf.spi.metadata.webservices.JBossWebserviceDescriptionMetaData;
import org.jboss.wsf.spi.metadata.webservices.JBossWebservicesMetaData;

abstract class AbstractMetaDataBuilderEJB {
    protected final Logger log = Logger.getLogger(this.getClass());

    AbstractMetaDataBuilderEJB() {
    }

    final EJBArchiveMetaData create(Deployment dep) {
        this.log.debug((Object)("Building JBoss agnostic meta data for EJB webservice deployment: " + dep.getSimpleName()));
        EJBArchiveMetaData ejbArchiveMD = new EJBArchiveMetaData();
        this.buildEnterpriseBeansMetaData(dep, ejbArchiveMD);
        this.buildWebservicesMetaData(dep, ejbArchiveMD);
        return ejbArchiveMD;
    }

    protected abstract void buildEnterpriseBeansMetaData(Deployment var1, EJBArchiveMetaData var2);

    private void buildWebservicesMetaData(Deployment dep, EJBArchiveMetaData ejbArchiveMD) {
        JBossWebservicesMetaData webservicesMD = (JBossWebservicesMetaData)WSHelper.getOptionalAttachment((Deployment)dep, JBossWebservicesMetaData.class);
        if (webservicesMD == null) {
            return;
        }
        String contextRoot = webservicesMD.getContextRoot();
        ejbArchiveMD.setWebServiceContextRoot(contextRoot);
        this.log.debug((Object)("Setting context root: " + contextRoot));
        String configName = webservicesMD.getConfigName();
        this.log.debug((Object)("Setting config name: " + configName));
        ejbArchiveMD.setConfigName(configName);
        String configFile = webservicesMD.getConfigFile();
        this.log.debug((Object)("Setting config file: " + configFile));
        ejbArchiveMD.setConfigFile(configFile);
        JBossWebserviceDescriptionMetaData[] wsDescriptionsMD = webservicesMD.getWebserviceDescriptions();
        PublishLocationAdapterImpl resolver = new PublishLocationAdapterImpl(wsDescriptionsMD);
        ejbArchiveMD.setPublishLocationAdapter((PublishLocationAdapter)resolver);
    }

    protected JBossPortComponentMetaData getPortComponent(String ejbName, JBossWebservicesMetaData jbossWebservicesMD) {
        if (jbossWebservicesMD == null) {
            return null;
        }
        for (JBossPortComponentMetaData jbossPortComponentMD : jbossWebservicesMD.getPortComponents()) {
            if (!ejbName.equals(jbossPortComponentMD.getEjbName())) continue;
            return jbossPortComponentMD;
        }
        return null;
    }
}

