/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservices.integration.security;

import java.util.ResourceBundle;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.logging.Logger;
import org.jboss.security.plugins.JaasSecurityDomain;
import org.jboss.webservices.integration.security.JaasSecurityDomainAdaptorImpl;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.wsf.spi.security.JAASSecurityDomainAdaptor;
import org.jboss.wsf.spi.security.JAASSecurityDomainAdaptorResolver;

public class JaasSecurityDomainAdaptorResolverImpl
implements JAASSecurityDomainAdaptorResolver {
    private static final ResourceBundle bundle = BundleUtils.getBundle(JaasSecurityDomainAdaptorResolverImpl.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JAASSecurityDomainAdaptor lookup(String jndi) throws Exception {
        JaasSecurityDomainAdaptorImpl jaasSecurityDomainAdaptorImpl;
        InitialContext ic = null;
        try {
            ic = new InitialContext();
            Object o = ic.lookup(jndi);
            if (!(o instanceof JaasSecurityDomain)) {
                throw new Exception(BundleUtils.getMessage((ResourceBundle)bundle, (String)"NOT_BUNDTO_JAASSECURITYDOMAIN", (Object[])new Object[]{jndi, o.getClass().getName()}));
            }
            jaasSecurityDomainAdaptorImpl = new JaasSecurityDomainAdaptorImpl((JaasSecurityDomain)o);
            if (ic == null) return jaasSecurityDomainAdaptorImpl;
        }
        catch (NamingException e) {
            try {
                throw new Exception(BundleUtils.getMessage((ResourceBundle)bundle, (String)"JNDI_FAILURE_HANDLING", (Object[])new Object[]{jndi}), e);
            }
            catch (Throwable throwable) {
                if (ic == null) throw throwable;
                try {
                    ic.close();
                    throw throwable;
                }
                catch (NamingException e2) {
                    Logger.getLogger(JaasSecurityDomainAdaptorImpl.class).warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"FAILED_TO_CLOSE_INITIALCONTEXT", (Object[])new Object[]{this}), (Throwable)e2);
                }
                throw throwable;
            }
        }
        try {
            ic.close();
            return jaasSecurityDomainAdaptorImpl;
        }
        catch (NamingException e) {
            Logger.getLogger(JaasSecurityDomainAdaptorImpl.class).warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"FAILED_TO_CLOSE_INITIALCONTEXT", (Object[])new Object[]{this}), (Throwable)e);
        }
        return jaasSecurityDomainAdaptorImpl;
    }
}

