/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservices.integration.weld;

import java.util.ResourceBundle;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.weld.integration.injection.NonContextualObjectInjectionHelper;
import org.jboss.weld.manager.api.WeldManager;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.invocation.AbstractInvocationHandlerJSE;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.invocation.Invocation;
import org.jboss.wsf.spi.invocation.InvocationHandler;

public final class WeldInvocationHandler
extends AbstractInvocationHandlerJSE {
    private static final ResourceBundle bundle = BundleUtils.getBundle(WeldInvocationHandler.class);
    private static final String BEAN_MANAGER_JNDI_NAME = "java:comp/BeanManager";
    private final InvocationHandler delegate;

    public WeldInvocationHandler(InvocationHandler delegate) {
        this.delegate = delegate;
    }

    public void onEndpointInstantiated(Endpoint endpoint, Invocation invocation) throws Exception {
        this.handleWeldInjection(invocation.getInvocationContext().getTargetBean());
        this.delegate.onEndpointInstantiated(endpoint, invocation);
    }

    public void onBeforeInvocation(Invocation invocation) throws Exception {
        this.delegate.onBeforeInvocation(invocation);
    }

    public void onAfterInvocation(Invocation invocation) throws Exception {
        this.delegate.onAfterInvocation(invocation);
    }

    private void handleWeldInjection(Object instance) {
        try {
            WeldManager beanManager = (WeldManager)new InitialContext().lookup(BEAN_MANAGER_JNDI_NAME);
            NonContextualObjectInjectionHelper.injectNonContextualInstance((Object)instance, (WeldManager)beanManager);
        }
        catch (NamingException e) {
            throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNABLE_TO_LOCATE_BEANMANAGER", (Object[])new Object[0]));
        }
    }
}

