/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2009, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.webservices.integration.security;

import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;

import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.web.WebPermissionMapping;
import org.jboss.wsf.common.integration.WSHelper;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.common.integration.AbstractDeploymentAspect;

/**
 * Generates JACC permissions. (This is temporary and really hacky solution). 
 * 
 * TODO: remove this deployment aspect and update 
 * particular JACC deployer to execute after 
 * JBossWS has modified web meta data. 
 *
 * @author <a href="mailto:ropalka@redhat.com">Richard Opalka</a>
 */
public final class JACCPermissionsDeploymentAspect extends AbstractDeploymentAspect
{

   /**
    * Constructor.
    */
   public JACCPermissionsDeploymentAspect()
   {
      super();
   }

   /**
    * JBAS-5935: The dynamic web application generated by the JBossWS
    * does not go through the war security deployer. Hence the JACC
    * permissions are not created. There is a need to explicitly create
    * the war jacc permissions.
    * 
    * @param dep webservice deployment
    */
   @Override
   public void start(final Deployment dep)
   {
      final JBossWebMetaData jbossWebMD = WSHelper.getRequiredAttachment(dep, JBossWebMetaData.class);

      try
      {
         final PolicyConfigurationFactory policyConfigurationFactory = PolicyConfigurationFactory
               .getPolicyConfigurationFactory();
         final PolicyConfiguration policyConfiguration = policyConfigurationFactory.getPolicyConfiguration(dep
               .getSimpleName(), false);

         WebPermissionMapping.createPermissions(jbossWebMD, policyConfiguration);
         policyConfiguration.commit();
      }
      catch (Exception e)
      {
         throw new RuntimeException("Exception generating JACC perms: ", e);
      }
   }

}
