/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss60.deployer;

import java.util.ArrayList;
import java.util.List;
import javax.jws.WebService;
import javax.xml.ws.WebServiceProvider;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.metadata.serviceref.VirtualFileAdaptor;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.ServletMetaData;
import org.jboss.wsf.container.jboss60.deployer.AbstractDeployerHookJSE;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.Service;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXWSDeployerHookPreJSE
extends AbstractDeployerHookJSE {
    @Override
    public Deployment.DeploymentType getDeploymentType() {
        return Deployment.DeploymentType.JAXWS_JSE;
    }

    @Override
    public Deployment createDeployment(DeploymentUnit unit) {
        ArchiveDeployment dep = this.newDeployment(unit);
        dep.setRootFile((UnifiedVirtualFile)new VirtualFileAdaptor(((VFSDeploymentUnit)unit).getRoot()));
        dep.setType(this.getDeploymentType());
        Service service = dep.getService();
        JBossWebMetaData webMetaData = (JBossWebMetaData)unit.getAttachment(JBossWebMetaData.class);
        if (webMetaData == null) {
            throw new IllegalStateException("Deployment unit does not contain web meta data");
        }
        dep.addAttachment(JBossWebMetaData.class, (Object)webMetaData);
        List<ServletMetaData> servlets = this.getRelevantServlets(webMetaData, unit.getClassLoader());
        for (ServletMetaData servlet : servlets) {
            String servletName = servlet.getName();
            String targetBean = this.getTargetBean(servlet);
            Endpoint ep = this.newEndpoint(targetBean);
            ep.setShortName(servletName);
            service.addEndpoint(ep);
        }
        return dep;
    }

    @Override
    public boolean isWebServiceDeployment(DeploymentUnit unit) {
        if (!super.isWebServiceDeployment(unit)) {
            return false;
        }
        boolean isWebServiceDeployment = false;
        try {
            JBossWebMetaData webMetaData = (JBossWebMetaData)unit.getAttachment(JBossWebMetaData.class);
            List<ServletMetaData> servlets = this.getRelevantServlets(webMetaData, unit.getClassLoader());
            isWebServiceDeployment = servlets.size() > 0;
        }
        catch (Exception ex) {
            this.log.error((Object)"Cannot process web deployment", (Throwable)ex);
        }
        return isWebServiceDeployment;
    }

    private List<ServletMetaData> getRelevantServlets(JBossWebMetaData webMetaData, ClassLoader loader) {
        ArrayList<ServletMetaData> servlets = new ArrayList<ServletMetaData>();
        for (JBossServletMetaData servlet : webMetaData.getServlets()) {
            String servletClassName = this.getTargetBean((ServletMetaData)servlet);
            if (servletClassName == null || servletClassName.length() == 0) continue;
            try {
                Class<?> servletClass = loader.loadClass(servletClassName.trim());
                boolean isWebService = servletClass.isAnnotationPresent(WebService.class);
                boolean isWebServiceProvider = servletClass.isAnnotationPresent(WebServiceProvider.class);
                if (!isWebService && !isWebServiceProvider) continue;
                servlets.add((ServletMetaData)servlet);
            }
            catch (ClassNotFoundException ex) {
                this.log.warn((Object)("Cannot load servlet class: " + servletClassName));
            }
        }
        return servlets;
    }
}

