/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployers;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ejb3.component.EJBViewDescription;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.webservices.metadata.WebServiceDeclaration;
import org.jboss.as.webservices.metadata.WebServiceDeployment;
import org.jboss.as.webservices.util.ASHelper;
import org.jboss.as.webservices.util.WSAttachmentKeys;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

public final class WSEJBIntegrationProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit unit = phaseContext.getDeploymentUnit();
        WebServiceDeploymentAdapter wsDeploymentAdapter = new WebServiceDeploymentAdapter();
        WSEJBIntegrationProcessor.processAnnotation(unit, ASHelper.WEB_SERVICE_ANNOTATION, wsDeploymentAdapter);
        WSEJBIntegrationProcessor.processAnnotation(unit, ASHelper.WEB_SERVICE_PROVIDER_ANNOTATION, wsDeploymentAdapter);
        if (!wsDeploymentAdapter.getServiceEndpoints().isEmpty()) {
            unit.putAttachment(WSAttachmentKeys.WEBSERVICE_DEPLOYMENT_KEY, (Object)wsDeploymentAdapter);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private static void processAnnotation(DeploymentUnit unit, DotName annotation, WebServiceDeployment wsDeployment) {
        List<AnnotationInstance> webServiceAnnotations = ASHelper.getAnnotations(unit, annotation);
        List<WebServiceDeclaration> endpoints = wsDeployment.getServiceEndpoints();
        EEModuleDescription moduleDescription = (EEModuleDescription)unit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        for (AnnotationInstance webServiceAnnotation : webServiceAnnotations) {
            AnnotationTarget target = webServiceAnnotation.target();
            ClassInfo webServiceClassInfo = (ClassInfo)target;
            String beanClassName = webServiceClassInfo.name().toString();
            List componentDescriptions = moduleDescription.getComponentsByClassName(beanClassName);
            List<SessionBeanComponentDescription> sessionBeans = WSEJBIntegrationProcessor.getSessionBeans(componentDescriptions);
            for (SessionBeanComponentDescription sessionBean : sessionBeans) {
                if (!sessionBean.isStateless() && !sessionBean.isSingleton()) continue;
                EJBViewDescription ejbViewDescription = sessionBean.addWebserviceEndpointView();
                String ejbViewName = ejbViewDescription.getServiceName().getCanonicalName();
                endpoints.add(new WebServiceDeclarationAdapter(sessionBean, webServiceClassInfo, ejbViewName));
            }
        }
    }

    private static List<SessionBeanComponentDescription> getSessionBeans(List<ComponentDescription> componentDescriptions) {
        ArrayList<SessionBeanComponentDescription> beans = new ArrayList<SessionBeanComponentDescription>(1);
        for (ComponentDescription componentDescription : componentDescriptions) {
            if (!(componentDescription instanceof SessionBeanComponentDescription)) continue;
            beans.add((SessionBeanComponentDescription)componentDescription);
        }
        return beans;
    }

    private static final class WebServiceDeploymentAdapter
    implements WebServiceDeployment {
        private final List<WebServiceDeclaration> endpoints = new ArrayList<WebServiceDeclaration>();

        private WebServiceDeploymentAdapter() {
        }

        @Override
        public List<WebServiceDeclaration> getServiceEndpoints() {
            return this.endpoints;
        }
    }

    private static final class WebServiceDeclarationAdapter
    implements WebServiceDeclaration {
        private final SessionBeanComponentDescription ejbMD;
        private final ClassInfo webServiceClassInfo;
        private final String containerName;

        private WebServiceDeclarationAdapter(SessionBeanComponentDescription ejbMD, ClassInfo webServiceClassInfo, String containerName) {
            this.ejbMD = ejbMD;
            this.webServiceClassInfo = webServiceClassInfo;
            this.containerName = containerName;
        }

        @Override
        public String getContainerName() {
            return this.containerName;
        }

        @Override
        public String getComponentName() {
            return this.ejbMD.getComponentName();
        }

        @Override
        public String getComponentClassName() {
            return this.ejbMD.getComponentClassName();
        }

        @Override
        public AnnotationInstance getAnnotation(DotName annotationType) {
            List list = (List)this.webServiceClassInfo.annotations().get(annotationType);
            if (list != null) {
                return (AnnotationInstance)list.get(0);
            }
            return null;
        }
    }
}

