/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployers;

import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.webservices.util.ASHelper;
import org.jboss.as.webservices.util.VirtualFileAdaptor;
import org.jboss.as.webservices.util.WSAttachmentKeys;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.logging.Logger;
import org.jboss.ws.common.deployment.SOAPAddressWSDLParser;
import org.jboss.wsf.spi.metadata.jms.JMSEndpointMetaData;
import org.jboss.wsf.spi.metadata.jms.JMSEndpointsMetaData;

public final class WSJMSIntegrationProcessor
implements DeploymentUnitProcessor {
    private static Logger LOG = Logger.getLogger(WSJMSIntegrationProcessor.class);
    private static final String WSDL_LOCATION = "wsdlLocation";
    private static final String PORT_NAME = "portName";
    private static final String SERVICE_NAME = "serviceName";
    private static final String TARGET_NAMESPACE = "targetNamespace";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit unit = phaseContext.getDeploymentUnit();
        List<AnnotationInstance> webServiceAnnotations = ASHelper.getAnnotations(unit, ASHelper.WEB_SERVICE_ANNOTATION);
        HashMap<String, LinkedList<AnnotationInstance>> map = new HashMap<String, LinkedList<AnnotationInstance>>();
        for (AnnotationInstance webServiceAnnotation : webServiceAnnotations) {
            AnnotationValue wsdlLocation = webServiceAnnotation.value(WSDL_LOCATION);
            AnnotationValue port = webServiceAnnotation.value(PORT_NAME);
            AnnotationValue service = webServiceAnnotation.value(SERVICE_NAME);
            if (wsdlLocation == null || port == null || service == null) continue;
            String key = wsdlLocation.asString();
            LinkedList<AnnotationInstance> annotations = (LinkedList<AnnotationInstance>)map.get(key);
            if (annotations == null) {
                annotations = new LinkedList<AnnotationInstance>();
                map.put(key, annotations);
            }
            annotations.add(webServiceAnnotation);
        }
        if (!map.isEmpty()) {
            JMSEndpointsMetaData endpointsMetaData = new JMSEndpointsMetaData();
            ResourceRoot deploymentRoot = (ResourceRoot)unit.getAttachment(Attachments.DEPLOYMENT_ROOT);
            VirtualFileAdaptor uvf = new VirtualFileAdaptor(deploymentRoot.getRoot());
            boolean trace = LOG.isTraceEnabled();
            for (String wsdlLocation : map.keySet()) {
                if (trace) {
                    LOG.tracef("Scanning wsdlLocation: %s", (Object)wsdlLocation);
                }
                try {
                    URL url = uvf.findChild(wsdlLocation).toURL();
                    SOAPAddressWSDLParser parser = new SOAPAddressWSDLParser(url);
                    for (AnnotationInstance ai : (List)map.get(wsdlLocation)) {
                        String soapAddress;
                        String port = ai.value(PORT_NAME).asString();
                        String service = ai.value(SERVICE_NAME).asString();
                        AnnotationValue targetNS = ai.value(TARGET_NAMESPACE);
                        String tns = targetNS != null ? targetNS.asString() : null;
                        QName serviceName = new QName(tns, service);
                        QName portName = new QName(tns, port);
                        if (trace) {
                            LOG.tracef("  serviceName: %s", (Object)serviceName);
                            LOG.tracef("  portName: %s", (Object)portName);
                        }
                        if ((soapAddress = parser.filterSoapAddress(serviceName, portName, "http://www.w3.org/2010/soapjms/")) == null) continue;
                        ClassInfo webServiceClassInfo = (ClassInfo)ai.target();
                        String beanClassName = webServiceClassInfo.name().toString();
                        JMSEndpointMetaData endpointMetaData = new JMSEndpointMetaData(endpointsMetaData);
                        endpointMetaData.setEndpointName(port);
                        endpointMetaData.setImplementor(beanClassName);
                        endpointMetaData.setSoapAddress(soapAddress);
                        endpointMetaData.setWsdlLocation(wsdlLocation);
                        endpointsMetaData.addEndpointMetaData(endpointMetaData);
                    }
                }
                catch (Exception e) {
                    if (trace) {
                        LOG.warnf("Could not read WSDL at '%s'", (Object)wsdlLocation, (Object)e);
                        continue;
                    }
                    LOG.warnf("Could not read WSDL at '%s'", (Object)wsdlLocation);
                }
            }
            if (!endpointsMetaData.getEndpointsMetaData().isEmpty()) {
                unit.putAttachment(WSAttachmentKeys.JMS_ENDPOINT_METADATA_KEY, (Object)endpointsMetaData);
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

