/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.tests;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.standalone.DeploymentAction;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlan;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.standalone.InitialDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentActionResult;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentManager;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentPlanResult;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.wsf.spi.deployer.Deployer;

public final class RemoteDeployer
implements Deployer {
    private static final Logger LOGGER = Logger.getLogger(RemoteDeployer.class);
    private static final int PORT = 9999;
    private final Map<URL, String> url2Id = new HashMap<URL, String>();
    private final InetAddress address = InetAddress.getByName("127.0.0.1");
    private final Map<String, Integer> securityDomainUsers = new HashMap<String, Integer>(1);
    private final Map<String, Integer> archiveCounters = new HashMap<String, Integer>();
    private ServerDeploymentManager deploymentManager = ServerDeploymentManager.Factory.create((InetAddress)this.address, (int)9999);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(URL archiveURL) throws Exception {
        Map<String, Integer> map = this.archiveCounters;
        synchronized (map) {
            String k = archiveURL.toString();
            if (this.archiveCounters.containsKey(k)) {
                int count = this.archiveCounters.get(k);
                this.archiveCounters.put(k, count + 1);
                return;
            }
            this.archiveCounters.put(k, 1);
            DeploymentPlanBuilder builder = this.deploymentManager.newDeploymentPlan().add(archiveURL).andDeploy();
            DeploymentPlan plan = builder.build();
            DeploymentAction deployAction = builder.getLastAction();
            String uniqueId = deployAction.getDeploymentUnitUniqueName();
            this.executeDeploymentPlan(plan, deployAction);
            this.url2Id.put(archiveURL, uniqueId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy(URL archiveURL) throws Exception {
        Map<String, Integer> map = this.archiveCounters;
        synchronized (map) {
            String k = archiveURL.toString();
            if (this.archiveCounters.containsKey(k)) {
                int count = this.archiveCounters.get(k);
                if (count > 1) {
                    this.archiveCounters.put(k, count - 1);
                    return;
                }
            } else {
                LOGGER.warn((Object)("Trying to undeploy archive " + archiveURL + " which is not currently deployed!"));
                return;
            }
            this.archiveCounters.remove(k);
            InitialDeploymentPlanBuilder builder = this.deploymentManager.newDeploymentPlan();
            String uniqueName = this.url2Id.get(archiveURL);
            if (uniqueName != null) {
                DeploymentPlan plan = builder.undeploy(uniqueName).remove(uniqueName).build();
                DeploymentAction deployAction = builder.getLastAction();
                try {
                    this.executeDeploymentPlan(plan, deployAction);
                }
                finally {
                    this.url2Id.remove(archiveURL);
                }
            }
        }
    }

    private void executeDeploymentPlan(DeploymentPlan plan, DeploymentAction deployAction) throws Exception {
        try {
            Exception deploymentException;
            ServerDeploymentActionResult actionResult;
            ServerDeploymentPlanResult planResult = (ServerDeploymentPlanResult)this.deploymentManager.execute(plan).get();
            if (deployAction != null && (actionResult = planResult.getDeploymentActionResult(deployAction.getId())) != null && (deploymentException = (Exception)actionResult.getDeploymentException()) != null) {
                throw deploymentException;
            }
        }
        catch (Exception e) {
            LOGGER.fatal((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSecurityDomain(String name, Map<String, String> authenticationOptions) throws Exception {
        Map<String, Integer> map = this.securityDomainUsers;
        synchronized (map) {
            if (this.securityDomainUsers.containsKey(name)) {
                int count = this.securityDomainUsers.get(name);
                this.securityDomainUsers.put(name, count + 1);
                return;
            }
            this.securityDomainUsers.put(name, 1);
            ModelControllerClient client = ModelControllerClient.Factory.create((InetAddress)this.address, (int)9999);
            ModelNode result = RemoteDeployer.createSecurityDomain(client, name, authenticationOptions);
            RemoteDeployer.checkResult(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSecurityDomain(String name) throws Exception {
        Map<String, Integer> map = this.securityDomainUsers;
        synchronized (map) {
            int count = this.securityDomainUsers.get(name);
            if (count > 1) {
                this.securityDomainUsers.put(name, count - 1);
                return;
            }
            this.securityDomainUsers.remove(name);
            ModelControllerClient client = ModelControllerClient.Factory.create((InetAddress)this.address, (int)9999);
            ModelNode result = RemoteDeployer.removeSecurityDomain(client, name);
            RemoteDeployer.checkResult(result);
        }
    }

    private static ModelNode createSecurityDomain(ModelControllerClient client, String name, Map<String, String> authenticationOptions) throws IOException {
        ModelNode op = new ModelNode();
        op.get("operation").set("add");
        op.get("address").add("subsystem", "security");
        op.get("address").add("security-domain", name);
        ModelNode loginModule = op.get("authentication").add();
        loginModule.get("code").set("UsersRoles");
        loginModule.get("flag").set("required");
        ModelNode moduleOptions = loginModule.get("module-options");
        if (authenticationOptions != null) {
            for (String k : authenticationOptions.keySet()) {
                moduleOptions.add(k, authenticationOptions.get(k));
            }
        }
        return client.execute(op);
    }

    private static ModelNode removeSecurityDomain(ModelControllerClient client, String name) throws IOException {
        ModelNode op = new ModelNode();
        op.get("operation").set("remove");
        op.get("address").add("subsystem", "security");
        op.get("address").add("security-domain", name);
        return client.execute(op);
    }

    private static void checkResult(ModelNode result) throws Exception {
        if (result.hasDefined("outcome") && "success".equals(result.get("outcome").asString())) {
            if (result.hasDefined("result")) {
                LOGGER.info((Object)result.get("result"));
            }
        } else {
            if (result.hasDefined("failure-description")) {
                throw new Exception(result.get("failure-description").toString());
            }
            throw new Exception("Operation not successful; outcome = " + result.get("outcome"));
        }
    }
}

