/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployers;

import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.DeploymentDescriptorEnvironment;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.webservices.deployers.AbstractIntegrationProcessorJAXWS;
import org.jboss.as.webservices.injection.WSEndpointHandlersMapping;
import org.jboss.as.webservices.metadata.model.EJBEndpoint;
import org.jboss.as.webservices.metadata.model.POJOEndpoint;
import org.jboss.as.webservices.util.ASHelper;
import org.jboss.as.webservices.util.DotNames;
import org.jboss.as.webservices.util.WSAttachmentKeys;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;

public final class WSIntegrationProcessorJAXWS_HANDLER
extends AbstractIntegrationProcessorJAXWS {
    public WSIntegrationProcessorJAXWS_HANDLER() {
        super(DotNames.HANDLER_CHAIN_ANNOTATION);
    }

    @Override
    protected void processAnnotation(DeploymentUnit unit, ClassInfo classInfo, AnnotationInstance wsAnnotation, CompositeIndex compositeIndex) throws DeploymentUnitProcessingException {
        WSEndpointHandlersMapping mapping = ASHelper.getRequiredAttachment(unit, WSAttachmentKeys.WS_ENDPOINT_HANDLERS_MAPPING_KEY);
        String endpointClassName = classInfo.name().toString();
        if (WSIntegrationProcessorJAXWS_HANDLER.isEjb3(classInfo)) {
            for (EJBEndpoint ejbEndpoint : ASHelper.getJaxwsEjbs(unit)) {
                if (!endpointClassName.equals(ejbEndpoint.getClassName())) continue;
                for (String handlerClassName : mapping.getHandlers(endpointClassName)) {
                    String ejbEndpointName = ejbEndpoint.getName();
                    String handlerName = ejbEndpointName + "-" + handlerClassName;
                    ComponentDescription jaxwsHandlerDescription = WSIntegrationProcessorJAXWS_HANDLER.createComponentDescription(unit, handlerName, handlerClassName, ejbEndpointName);
                    WSIntegrationProcessorJAXWS_HANDLER.propagateNamingContext(jaxwsHandlerDescription, ejbEndpoint);
                }
            }
        } else {
            for (POJOEndpoint pojoEndpoint : ASHelper.getJaxwsPojos(unit)) {
                if (!endpointClassName.equals(pojoEndpoint.getClassName())) continue;
                for (String handlerClassName : mapping.getHandlers(endpointClassName)) {
                    String pojoEndpointName = pojoEndpoint.getName();
                    String handlerName = pojoEndpointName + "-" + handlerClassName;
                    WSIntegrationProcessorJAXWS_HANDLER.createComponentDescription(unit, handlerName, handlerClassName, pojoEndpointName);
                }
            }
        }
    }

    private static void propagateNamingContext(ComponentDescription jaxwsHandlerDescription, EJBEndpoint ejbEndpoint) {
        ServiceName ejbContextServiceName = ejbEndpoint.getContextServiceName();
        DeploymentDescriptorEnvironment ejbEnv = ejbEndpoint.getDeploymentDescriptorEnvironment();
        jaxwsHandlerDescription.setContextServiceName(ejbContextServiceName);
        jaxwsHandlerDescription.setDeploymentDescriptorEnvironment(ejbEnv);
        jaxwsHandlerDescription.addDependency(ejbContextServiceName, ServiceBuilder.DependencyType.REQUIRED);
    }
}

