/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.tests;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.client.helpers.standalone.DeploymentAction;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlan;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.standalone.InitialDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentActionResult;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentManager;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentPlanResult;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.wsf.spi.deployer.Deployer;

public final class RemoteDeployer
implements Deployer {
    private static final Logger LOGGER = Logger.getLogger(RemoteDeployer.class);
    private static final int PORT = 9999;
    private static final String JBWS_DEPLOYER_AUTH_USER = "jbossws.deployer.authentication.username";
    private static final String JBWS_DEPLOYER_AUTH_PWD = "jbossws.deployer.authentication.password";
    private final Map<URL, String> url2Id = new HashMap<URL, String>();
    private final InetAddress address = InetAddress.getByName("127.0.0.1");
    private final CallbackHandler callbackHandler = RemoteDeployer.getCallbackHandler();
    private final ServerDeploymentManager deploymentManager;
    private final Map<String, Integer> securityDomainUsers = new HashMap<String, Integer>(1);
    private final Map<String, Integer> archiveCounters = new HashMap<String, Integer>();

    public RemoteDeployer() throws IOException {
        this.deploymentManager = ServerDeploymentManager.Factory.create((InetAddress)this.address, (int)9999, (CallbackHandler)this.callbackHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(URL archiveURL) throws Exception {
        Map<String, Integer> map = this.archiveCounters;
        synchronized (map) {
            String k = archiveURL.toString();
            if (this.archiveCounters.containsKey(k)) {
                int count = this.archiveCounters.get(k);
                this.archiveCounters.put(k, count + 1);
                return;
            }
            this.archiveCounters.put(k, 1);
            DeploymentPlanBuilder builder = this.deploymentManager.newDeploymentPlan().add(archiveURL).andDeploy();
            DeploymentPlan plan = builder.build();
            DeploymentAction deployAction = builder.getLastAction();
            String uniqueId = deployAction.getDeploymentUnitUniqueName();
            this.executeDeploymentPlan(plan, deployAction);
            this.url2Id.put(archiveURL, uniqueId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy(URL archiveURL) throws Exception {
        Map<String, Integer> map = this.archiveCounters;
        synchronized (map) {
            String k = archiveURL.toString();
            if (this.archiveCounters.containsKey(k)) {
                int count = this.archiveCounters.get(k);
                if (count > 1) {
                    this.archiveCounters.put(k, count - 1);
                    return;
                }
            } else {
                LOGGER.warn((Object)("Trying to undeploy archive " + archiveURL + " which is not currently deployed!"));
                return;
            }
            this.archiveCounters.remove(k);
            InitialDeploymentPlanBuilder builder = this.deploymentManager.newDeploymentPlan();
            String uniqueName = this.url2Id.get(archiveURL);
            if (uniqueName != null) {
                DeploymentPlan plan = builder.undeploy(uniqueName).remove(uniqueName).build();
                DeploymentAction deployAction = builder.getLastAction();
                try {
                    this.executeDeploymentPlan(plan, deployAction);
                }
                finally {
                    this.url2Id.remove(archiveURL);
                }
            }
        }
    }

    private void executeDeploymentPlan(DeploymentPlan plan, DeploymentAction deployAction) throws Exception {
        try {
            Exception deploymentException;
            ServerDeploymentActionResult actionResult;
            ServerDeploymentPlanResult planResult = (ServerDeploymentPlanResult)this.deploymentManager.execute(plan).get();
            if (deployAction != null && (actionResult = planResult.getDeploymentActionResult(deployAction.getId())) != null && (deploymentException = (Exception)actionResult.getDeploymentException()) != null) {
                throw deploymentException;
            }
        }
        catch (Exception e) {
            LOGGER.fatal((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public String getServerVersion() throws Exception {
        ModelNode request = new ModelNode();
        request.get("operation").set("read-attribute");
        request.get("address").setEmptyList();
        request.get("name").set("release-version");
        ModelNode response = RemoteDeployer.applyUpdate(request, this.getModelControllerClient());
        return response.get("result").asString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSecurityDomain(String name, Map<String, String> authenticationOptions) throws Exception {
        Map<String, Integer> map = this.securityDomainUsers;
        synchronized (map) {
            if (this.securityDomainUsers.containsKey(name)) {
                int count = this.securityDomainUsers.get(name);
                this.securityDomainUsers.put(name, count + 1);
                return;
            }
            this.securityDomainUsers.put(name, 1);
            ArrayList<ModelNode> updates = new ArrayList<ModelNode>();
            ModelNode op = new ModelNode();
            op.get("operation").set("add");
            op.get("address").add("subsystem", "security");
            op.get("address").add("security-domain", name);
            updates.add(op);
            op = new ModelNode();
            op.get("operation").set("add");
            op.get("address").add("subsystem", "security");
            op.get("address").add("security-domain", name);
            op.get("address").add("authentication", "classic");
            ModelNode loginModule = op.get("login-modules").add();
            loginModule.get("code").set("UsersRoles");
            loginModule.get("flag").set("required");
            op.get("operation-headers").get("allow-resource-service-restart").set(true);
            updates.add(op);
            ModelNode moduleOptions = loginModule.get("module-options");
            if (authenticationOptions != null) {
                for (String k : authenticationOptions.keySet()) {
                    moduleOptions.add(k, authenticationOptions.get(k));
                }
            }
            RemoteDeployer.applyUpdates(updates, this.getModelControllerClient());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSecurityDomain(String name) throws Exception {
        Map<String, Integer> map = this.securityDomainUsers;
        synchronized (map) {
            int count = this.securityDomainUsers.get(name);
            if (count > 1) {
                this.securityDomainUsers.put(name, count - 1);
                return;
            }
            this.securityDomainUsers.remove(name);
            ModelNode op = new ModelNode();
            op.get("operation").set("remove");
            op.get("address").add("subsystem", "security");
            op.get("address").add("security-domain", name);
            op.get(new String[]{"operation-headers", "rollback-on-runtime-failure"}).set(false);
            RemoteDeployer.applyUpdate(op, this.getModelControllerClient());
        }
    }

    private ModelControllerClient getModelControllerClient() {
        return ModelControllerClient.Factory.create((InetAddress)this.address, (int)9999, (CallbackHandler)this.callbackHandler);
    }

    private static void applyUpdates(List<ModelNode> updates, ModelControllerClient client) throws Exception {
        for (ModelNode update : updates) {
            RemoteDeployer.applyUpdate(update, client);
        }
    }

    private static ModelNode applyUpdate(ModelNode update, ModelControllerClient client) throws Exception {
        ModelNode result = client.execute(new OperationBuilder(update).build());
        RemoteDeployer.checkResult(result);
        return result;
    }

    private static void checkResult(ModelNode result) throws Exception {
        if (result.hasDefined("outcome") && "success".equals(result.get("outcome").asString())) {
            if (result.hasDefined("result")) {
                LOGGER.info((Object)result.get("result"));
            }
        } else {
            if (result.hasDefined("failure-description")) {
                throw new Exception(result.get("failure-description").toString());
            }
            throw new Exception("Operation not successful; outcome = " + result.get("outcome"));
        }
    }

    private static CallbackHandler getCallbackHandler() {
        final String username = RemoteDeployer.getSystemProperty(JBWS_DEPLOYER_AUTH_USER, null);
        if (username == null || "${jbossws.deployer.authentication.username}".equals(username)) {
            return null;
        }
        String pwd = RemoteDeployer.getSystemProperty(JBWS_DEPLOYER_AUTH_PWD, null);
        if ("${jbossws.deployer.authentication.password}".equals(pwd)) {
            pwd = null;
        }
        final String password = pwd;
        return new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (Callback current : callbacks) {
                    if (current instanceof NameCallback) {
                        NameCallback ncb = (NameCallback)current;
                        ncb.setName(username);
                        continue;
                    }
                    if (current instanceof PasswordCallback) {
                        PasswordCallback pcb = (PasswordCallback)current;
                        pcb.setPassword(password.toCharArray());
                        continue;
                    }
                    if (current instanceof RealmCallback) {
                        RealmCallback rcb = (RealmCallback)current;
                        rcb.setText(rcb.getDefaultText());
                        continue;
                    }
                    if (current instanceof RealmChoiceCallback) continue;
                    throw new UnsupportedCallbackException(current);
                }
            }
        };
    }

    private static String getSystemProperty(final String name, final String defaultValue) {
        PrivilegedAction<String> action = new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(name, defaultValue);
            }
        };
        return AccessController.doPrivileged(action);
    }
}

