/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployers;

import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.webservices.service.EndpointService;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.ws.common.deployment.EndpointLifecycleDeploymentAspect;
import org.jboss.ws.common.integration.WSHelper;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.LifecycleHandler;

public final class EndpointServiceDeploymentAspect
extends EndpointLifecycleDeploymentAspect
implements Cloneable {
    private boolean stopServices = false;

    public void start(Deployment dep) {
        ServiceTarget target = (ServiceTarget)WSHelper.getOptionalAttachment((Deployment)dep, ServiceTarget.class);
        DeploymentUnit unit = (DeploymentUnit)WSHelper.getRequiredAttachment((Deployment)dep, DeploymentUnit.class);
        for (Endpoint ep : dep.getService().getEndpoints()) {
            EndpointService.install(target, ep, unit);
            this.getLifecycleHandler(ep, true).start(ep);
        }
    }

    public void stop(Deployment dep) {
        if (this.stopServices) {
            DeploymentUnit unit = (DeploymentUnit)WSHelper.getRequiredAttachment((Deployment)dep, DeploymentUnit.class);
            for (Endpoint ep : dep.getService().getEndpoints()) {
                LifecycleHandler lifecycleHandler = this.getLifecycleHandler(ep, false);
                if (lifecycleHandler != null) {
                    lifecycleHandler.stop(ep);
                }
                EndpointService.uninstall(ep, unit);
            }
        } else {
            super.stop(dep);
        }
    }

    public void setStopServices(boolean stopServices) {
        this.stopServices = stopServices;
    }

    public Object clone() {
        EndpointServiceDeploymentAspect clone = new EndpointServiceDeploymentAspect();
        clone.setForJaxRpc(this.isForJaxRpc());
        clone.setForJaxWs(this.isForJaxWs());
        clone.setLast(this.isLast());
        clone.setProvides(this.getProvides());
        clone.setRelativeOrder(this.getRelativeOrder());
        clone.setRequires(this.getRequires());
        clone.setStopServices(this.stopServices);
        return clone;
    }
}

