/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.test;

import java.io.File;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.ws.Service;
import javax.xml.ws.handler.HandlerResolver;
import org.jboss.logging.Logger;
import org.jboss.ws.common.ObjectNameFactory;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployer.Deployer;

public class JBossWSTestHelper {
    private static final Logger LOGGER = Logger.getLogger(JBossWSTestHelper.class);
    private static final String SYSPROP_JBOSSWS_INTEGRATION_TARGET = "jbossws.integration.target";
    private static final String SYSPROP_JBOSS_BIND_ADDRESS = "jboss.bind.address";
    private static final String SYSPROP_TEST_ARCHIVE_DIRECTORY = "test.archive.directory";
    private static final String SYSPROP_TEST_RESOURCES_DIRECTORY = "test.resources.directory";
    private static final Deployer DEPLOYER;
    private static MBeanServerConnection server;
    private static String integrationTarget;
    private static String implVendor;
    private static String implTitle;
    private static String implVersion;
    private static String testArchiveDir;
    private static String testResourcesDir;

    public static void deploy(String archive) throws Exception {
        URL archiveURL = JBossWSTestHelper.getArchiveFile(archive).toURI().toURL();
        DEPLOYER.deploy(archiveURL);
    }

    public static void undeploy(String archive) throws Exception {
        URL archiveURL = JBossWSTestHelper.getArchiveFile(archive).toURI().toURL();
        DEPLOYER.undeploy(archiveURL);
    }

    public static boolean isTargetJBoss6() {
        String target = JBossWSTestHelper.getIntegrationTarget();
        return target.startsWith("jboss6");
    }

    public static boolean isIntegrationNative() {
        String vendor = JBossWSTestHelper.getImplementationVendor();
        return vendor.toLowerCase().indexOf("jboss") != -1;
    }

    public static boolean isIntegrationCXF() {
        String vendor = JBossWSTestHelper.getImplementationVendor();
        return vendor.toLowerCase().indexOf("apache") != -1;
    }

    private static String getImplementationVendor() {
        if (implVendor == null) {
            Object obj = JBossWSTestHelper.getImplementationObject();
            implVendor = obj.getClass().getPackage().getImplementationVendor();
            if (implVendor == null) {
                implVendor = JBossWSTestHelper.getImplementationPackage();
            }
            implTitle = obj.getClass().getPackage().getImplementationTitle();
            implVersion = obj.getClass().getPackage().getImplementationVersion();
            System.out.println(implVendor + ", " + implTitle + ", " + implVersion);
        }
        return implVendor;
    }

    private static Object getImplementationObject() {
        Service service = Service.create((QName)new QName("dummyService"));
        HandlerResolver obj = service.getHandlerResolver();
        if (obj == null) {
            service.addPort(new QName("dummyPort"), "http://schemas.xmlsoap.org/wsdl/soap/http", "http://dummy-address");
            obj = service.createDispatch(new QName("dummyPort"), Source.class, Service.Mode.PAYLOAD);
        }
        return obj;
    }

    private static String getImplementationPackage() {
        return JBossWSTestHelper.getImplementationObject().getClass().getPackage().getName();
    }

    public static String getServerHost() {
        String host = System.getProperty(SYSPROP_JBOSS_BIND_ADDRESS, "localhost");
        return JBossWSTestHelper.toIPv6URLFormat(host);
    }

    private static String toIPv6URLFormat(String host) {
        try {
            boolean isIPv6Address = InetAddress.getByName(host) instanceof Inet6Address;
            boolean isIPv6Formatted = isIPv6Address && host.startsWith("[");
            return isIPv6Address && !isIPv6Formatted ? "[" + host + "]" : host;
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public static MBeanServerConnection getServer() {
        if (server == null) {
            server = JBossWSTestHelper.getIntegrationTarget().startsWith("jboss7") ? JBossWSTestHelper.getAS7ServerConnection() : JBossWSTestHelper.getAS6ServerConnection();
        }
        return server;
    }

    private static MBeanServerConnection getAS7ServerConnection() {
        String host = JBossWSTestHelper.getServerHost();
        String urlString = System.getProperty("jmx.service.url", "service:jmx:rmi:///jndi/rmi://" + host + ":" + 1090 + "/jmxrmi");
        try {
            JMXServiceURL serviceURL = new JMXServiceURL(urlString);
            return JMXConnectorFactory.connect(serviceURL, null).getMBeanServerConnection();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot obtain MBeanServerConnection to: " + urlString, ex);
        }
    }

    private static MBeanServerConnection getAS6ServerConnection() {
        Hashtable<?, ?> jndiEnv = null;
        try {
            InitialContext iniCtx = new InitialContext();
            jndiEnv = iniCtx.getEnvironment();
            return (MBeanServerConnection)iniCtx.lookup("jmx/invoker/RMIAdaptor");
        }
        catch (NamingException ex) {
            throw new RuntimeException("Cannot obtain MBeanServerConnection using jndi props: " + jndiEnv, ex);
        }
    }

    public static String getIntegrationTarget() {
        if (integrationTarget == null) {
            integrationTarget = System.getProperty(SYSPROP_JBOSSWS_INTEGRATION_TARGET);
            if (integrationTarget == null) {
                throw new IllegalStateException("Cannot obtain system property: jbossws.integration.target");
            }
            LOGGER.warn((Object)"TODO: [JBWS-3211] include AS 7.x into integrationTarget mismatch check");
            if (!integrationTarget.startsWith("jboss7")) {
                String jbossVersion;
                block11: {
                    jbossVersion = null;
                    try {
                        ObjectName oname = ObjectNameFactory.create((String)"jboss.system:type=Server");
                        jbossVersion = (String)JBossWSTestHelper.getServer().getAttribute(oname, "VersionNumber");
                        if (jbossVersion == null) {
                            throw new IllegalStateException("Cannot obtain jboss version");
                        }
                        if (jbossVersion.startsWith("5.1")) {
                            jbossVersion = "jboss51";
                            break block11;
                        }
                        if (jbossVersion.startsWith("5.0")) {
                            jbossVersion = "jboss50";
                            break block11;
                        }
                        if (jbossVersion.startsWith("6.1")) {
                            jbossVersion = "jboss61";
                            break block11;
                        }
                        if (jbossVersion.startsWith("6.0")) {
                            jbossVersion = "jboss60";
                            break block11;
                        }
                        throw new IllegalStateException("Unsupported jboss version: " + jbossVersion);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
                if (!integrationTarget.startsWith(jbossVersion)) {
                    throw new IllegalStateException("Integration target mismatch: " + integrationTarget + ".startsWith(" + jbossVersion + ")");
                }
            }
        }
        return integrationTarget;
    }

    public static URL getArchiveURL(String archive) throws MalformedURLException {
        return JBossWSTestHelper.getArchiveFile(archive).toURI().toURL();
    }

    public static File getArchiveFile(String archive) {
        File file = new File(archive);
        if (file.exists()) {
            return file;
        }
        file = new File(JBossWSTestHelper.getTestArchiveDir() + "/" + archive);
        if (file.exists()) {
            return file;
        }
        String notSet = JBossWSTestHelper.getTestArchiveDir() == null ? " System property 'test.archive.directory' not set." : "";
        throw new IllegalArgumentException("Cannot obtain '" + JBossWSTestHelper.getTestArchiveDir() + "/" + archive + "'." + notSet);
    }

    public static URL getResourceURL(String resource) throws MalformedURLException {
        return JBossWSTestHelper.getResourceFile(resource).toURI().toURL();
    }

    public static File getResourceFile(String resource) {
        File file = new File(resource);
        if (file.exists()) {
            return file;
        }
        file = new File(JBossWSTestHelper.getTestResourcesDir() + "/" + resource);
        if (file.exists()) {
            return file;
        }
        String notSet = JBossWSTestHelper.getTestResourcesDir() == null ? " System property 'test.resources.directory' not set." : "";
        throw new IllegalArgumentException("Cannot obtain '" + JBossWSTestHelper.getTestResourcesDir() + "/" + resource + "'." + notSet);
    }

    public static String getTestArchiveDir() {
        if (testArchiveDir == null) {
            testArchiveDir = System.getProperty(SYSPROP_TEST_ARCHIVE_DIRECTORY);
        }
        return testArchiveDir;
    }

    public static String getTestResourcesDir() {
        if (testResourcesDir == null) {
            testResourcesDir = System.getProperty(SYSPROP_TEST_RESOURCES_DIRECTORY);
        }
        return testResourcesDir;
    }

    public static void addSecurityDomain(String name, Map<String, String> authenticationOptions) throws Exception {
        DEPLOYER.addSecurityDomain(name, authenticationOptions);
    }

    public static void removeSecurityDomain(String name) throws Exception {
        DEPLOYER.removeSecurityDomain(name);
    }

    static {
        SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
        DEPLOYER = (Deployer)spiProvider.getSPI(Deployer.class);
    }
}

